package de.adorsys.psd2.event.persist.mapper;

import de.adorsys.psd2.event.persist.entity.EventEntity;
import de.adorsys.psd2.event.persist.entity.PsuDataEmbeddable;
import de.adorsys.psd2.event.persist.model.EventPO;
import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import java.util.Arrays;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-09-13T15:15:04+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class EventDBMapperImpl implements EventDBMapper {

    @Override
    public EventEntity toEventEntity(EventPO eventPO) {
        if ( eventPO == null ) {
            return null;
        }

        EventEntity eventEntity = new EventEntity();

        eventEntity.setPsuData( psuIdDataPOToPsuDataEmbeddable( eventPO.getPsuIdData() ) );
        eventEntity.setId( eventPO.getId() );
        eventEntity.setTimestamp( eventPO.getTimestamp() );
        eventEntity.setConsentId( eventPO.getConsentId() );
        eventEntity.setPaymentId( eventPO.getPaymentId() );
        byte[] payload = eventPO.getPayload();
        if ( payload != null ) {
            eventEntity.setPayload( Arrays.copyOf( payload, payload.length ) );
        }
        eventEntity.setEventOrigin( eventPO.getEventOrigin() );
        eventEntity.setEventType( eventPO.getEventType() );
        eventEntity.setTppAuthorisationNumber( eventPO.getTppAuthorisationNumber() );
        eventEntity.setXRequestId( eventPO.getXRequestId() );
        if ( eventPO.getInstanceId() != null ) {
            eventEntity.setInstanceId( eventPO.getInstanceId() );
        }
        else {
            eventEntity.setInstanceId( "UNDEFINED" );
        }
        eventEntity.setInternalRequestId( eventPO.getInternalRequestId() );

        return eventEntity;
    }

    protected PsuDataEmbeddable psuIdDataPOToPsuDataEmbeddable(PsuIdDataPO psuIdDataPO) {
        if ( psuIdDataPO == null ) {
            return null;
        }

        PsuDataEmbeddable psuDataEmbeddable = new PsuDataEmbeddable();

        psuDataEmbeddable.setPsuId( psuIdDataPO.getPsuId() );
        psuDataEmbeddable.setPsuIdType( psuIdDataPO.getPsuIdType() );
        psuDataEmbeddable.setPsuCorporateId( psuIdDataPO.getPsuCorporateId() );
        psuDataEmbeddable.setPsuCorporateIdType( psuIdDataPO.getPsuCorporateIdType() );

        return psuDataEmbeddable;
    }
}
