/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.event.persist;

import de.adorsys.psd2.event.persist.EventRepository;
import de.adorsys.psd2.event.persist.entity.EventEntity;
import de.adorsys.psd2.event.persist.jpa.EventJPARepository;
import de.adorsys.psd2.event.persist.mapper.EventDBMapper;
import de.adorsys.psd2.event.persist.model.EventPO;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EventRepositoryImpl
implements EventRepository {
    private final EventJPARepository eventRepository;
    private final EventDBMapper eventDBMapper;

    @Transactional
    public Long save(EventPO eventPO) {
        EventEntity entity = this.eventDBMapper.toEventEntity(eventPO);
        this.eventRepository.save(entity);
        return entity.getId();
    }

    @ConstructorProperties(value={"eventRepository", "eventDBMapper"})
    public EventRepositoryImpl(EventJPARepository eventRepository, EventDBMapper eventDBMapper) {
        this.eventRepository = eventRepository;
        this.eventDBMapper = eventDBMapper;
    }
}

