/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report.mapper;

import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.report.entity.EventEntityForReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;

@Mapper(componentModel="spring")
public interface EventReportDBMapper {
    public ReportEvent mapToReportEvent(EventEntityForReport var1);

    @AfterMapping
    default public void mapToReportEventAfterMapping(EventEntityForReport event, @MappingTarget ReportEvent reportEvent) {
        reportEvent.setPsuIdData(this.getPsuIdDataPOSet(event));
    }

    default public Set<PsuIdDataPO> getPsuIdDataPOSet(EventEntityForReport event) {
        HashSet<PsuIdDataPO> psus = new HashSet<PsuIdDataPO>();
        if (StringUtils.isNotBlank((CharSequence)event.getPsuId())) {
            psus.add(this.mapToPsuIdDataPO(event.getPsuId(), event.getPsuIdType(), event.getPsuCorporateId(), event.getPsuCorporateIdType()));
        } else if (StringUtils.isNotBlank((CharSequence)event.getPsuExId())) {
            psus.add(this.mapToPsuIdDataPO(event.getPsuExId(), event.getPsuExIdType(), event.getPsuExCorporateId(), event.getPsuExCorporateIdType()));
        }
        return psus;
    }

    default public PsuIdDataPO mapToPsuIdDataPO(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        PsuIdDataPO psuIdDataPO = new PsuIdDataPO();
        psuIdDataPO.setPsuId(psuId);
        psuIdDataPO.setPsuIdType(psuIdType);
        psuIdDataPO.setPsuCorporateId(psuCorporateId);
        psuIdDataPO.setPsuCorporateIdType(psuCorporateIdType);
        return psuIdDataPO;
    }

    default public List<ReportEvent> mapToAspspReportEvents(List<EventEntityForReport> events) {
        Collection eventCollection = events.stream().map(this::mapToReportEvent).collect(Collectors.toMap(ReportEvent::getId, Function.identity(), ReportEvent::merge)).values();
        return new ArrayList<ReportEvent>(eventCollection);
    }
}

