/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report.jpa;

import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.report.entity.EventEntityForReport;
import de.adorsys.psd2.report.jpa.builder.EventReportSqlParameterSourceBuilder;
import de.adorsys.psd2.report.jpa.builder.SqlEventReportBuilder;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class EventReportJPARepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final SqlEventReportBuilder sqlEventReportBuilder;

    public List<EventEntityForReport> getEventsForPeriod(OffsetDateTime periodFrom, OffsetDateTime periodTo, String instanceId) {
        EventReportSqlParameterSourceBuilder parameters = new EventReportSqlParameterSourceBuilder().periodFrom(periodFrom).periodTo(periodTo).instanceId(instanceId).build();
        String sqlRequest = this.sqlEventReportBuilder.baseRequest().period().instanceId().build();
        return this.namedParameterJdbcTemplate.query(sqlRequest, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(EventEntityForReport.class));
    }

    public List<EventEntityForReport> findByTimestampBetweenAndConsentIdAndInstanceIdOrderByTimestampAsc(OffsetDateTime periodFrom, OffsetDateTime periodTo, String consentId, String instanceId) {
        EventReportSqlParameterSourceBuilder parameters = new EventReportSqlParameterSourceBuilder().periodFrom(periodFrom).periodTo(periodTo).instanceId(instanceId).consentId(consentId).build();
        String sqlRequest = this.sqlEventReportBuilder.baseRequest().period().instanceId().consentId().build();
        return this.namedParameterJdbcTemplate.query(sqlRequest, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(EventEntityForReport.class));
    }

    public List<EventEntityForReport> findByTimestampBetweenAndPaymentIdAndInstanceIdOrderByTimestampAsc(OffsetDateTime periodFrom, OffsetDateTime periodTo, String paymentId, String instanceId) {
        EventReportSqlParameterSourceBuilder parameters = new EventReportSqlParameterSourceBuilder().periodFrom(periodFrom).periodTo(periodTo).instanceId(instanceId).paymentId(paymentId).build();
        String sqlRequest = this.sqlEventReportBuilder.baseRequest().period().instanceId().paymentId().build();
        return this.namedParameterJdbcTemplate.query(sqlRequest, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(EventEntityForReport.class));
    }

    public List<EventEntityForReport> findByTimestampBetweenAndEventTypeAndInstanceIdOrderByTimestampAsc(OffsetDateTime periodFrom, OffsetDateTime periodTo, EventType eventType, String instanceId) {
        EventReportSqlParameterSourceBuilder parameters = new EventReportSqlParameterSourceBuilder().periodFrom(periodFrom).periodTo(periodTo).instanceId(instanceId).eventType(eventType).build();
        String sqlRequest = this.sqlEventReportBuilder.baseRequest().period().instanceId().eventType().build();
        return this.namedParameterJdbcTemplate.query(sqlRequest, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(EventEntityForReport.class));
    }

    public List<EventEntityForReport> findByTimestampBetweenAndEventOriginAndInstanceIdOrderByTimestampAsc(OffsetDateTime periodFrom, OffsetDateTime periodTo, EventOrigin eventOrigin, String instanceId) {
        EventReportSqlParameterSourceBuilder parameters = new EventReportSqlParameterSourceBuilder().periodFrom(periodFrom).periodTo(periodTo).instanceId(instanceId).eventOrigin(eventOrigin).build();
        String sqlRequest = this.sqlEventReportBuilder.baseRequest().period().instanceId().eventOrigin().build();
        return this.namedParameterJdbcTemplate.query(sqlRequest, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(EventEntityForReport.class));
    }

    @ConstructorProperties(value={"namedParameterJdbcTemplate", "sqlEventReportBuilder"})
    public EventReportJPARepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate, SqlEventReportBuilder sqlEventReportBuilder) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.sqlEventReportBuilder = sqlEventReportBuilder;
    }
}

