/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report;

import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.event.persist.EventReportRepository;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.report.entity.EventReportEntity;
import de.adorsys.psd2.report.jpa.EventReportJPARepository;
import de.adorsys.psd2.report.mapper.EventReportDBMapper;
import de.adorsys.psd2.report.specification.EventSpecification;
import de.adorsys.psd2.report.util.EventPageRequestBuilder;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EventReportRepositoryImpl
implements EventReportRepository {
    private final EventReportDBMapper eventReportDBMapper;
    private final EventReportJPARepository eventJpaRepository;
    private final EventSpecification eventSpecification;
    private final EventPageRequestBuilder pageRequestBuilder;

    public List<ReportEvent> getEventsForPeriod(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        Pageable pageable = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        List<EventReportEntity> events = this.eventJpaRepository.findAll(this.eventSpecification.byPeriodAndInstanceId(start, end, instanceId), pageable).stream().collect(Collectors.toList());
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndConsentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String consentId, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        Pageable pageable = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        List<EventReportEntity> events = this.eventJpaRepository.findAll(this.eventSpecification.byPeriodAndInstanceIdAndConsentId(start, end, instanceId, consentId), pageable).stream().collect(Collectors.toList());
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndPaymentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String paymentId, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        Pageable pageable = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        List<EventReportEntity> events = this.eventJpaRepository.findAll(this.eventSpecification.byPeriodAndInstanceIdAndPaymentId(start, end, instanceId, paymentId), pageable).stream().collect(Collectors.toList());
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndEventType(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventType eventType, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        Pageable pageable = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        List<EventReportEntity> events = this.eventJpaRepository.findAll(this.eventSpecification.byPeriodAndInstanceIdAndEventType(start, end, instanceId, eventType), pageable).stream().collect(Collectors.toList());
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndEventOrigin(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventOrigin eventOrigin, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        Pageable pageable = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        List<EventReportEntity> events = this.eventJpaRepository.findAll(this.eventSpecification.byPeriodAndInstanceIdAndEventOrigin(start, end, instanceId, eventOrigin), pageable).stream().collect(Collectors.toList());
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    @ConstructorProperties(value={"eventReportDBMapper", "eventJpaRepository", "eventSpecification", "pageRequestBuilder"})
    public EventReportRepositoryImpl(EventReportDBMapper eventReportDBMapper, EventReportJPARepository eventJpaRepository, EventSpecification eventSpecification, EventPageRequestBuilder pageRequestBuilder) {
        this.eventReportDBMapper = eventReportDBMapper;
        this.eventJpaRepository = eventJpaRepository;
        this.eventSpecification = eventSpecification;
        this.pageRequestBuilder = pageRequestBuilder;
    }
}

