package de.adorsys.psd2.report.mapper;

import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.report.entity.EventConsentEntity;
import de.adorsys.psd2.report.entity.EventPaymentEntity;
import de.adorsys.psd2.report.entity.EventReportEntity;
import java.util.Arrays;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-06-16T13:56:31+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.11 (Azul Systems, Inc.)"
)
@Component
public class EventReportDBMapperImpl implements EventReportDBMapper {

    @Override
    public ReportEvent mapToReportEvent(EventReportEntity event) {
        if ( event == null ) {
            return null;
        }

        ReportEvent reportEvent = new ReportEvent();

        reportEvent.setConsentId( eventConsentExternalId( event ) );
        reportEvent.setPaymentId( eventPaymentPaymentId( event ) );
        reportEvent.setId( event.getId() );
        reportEvent.setTimestamp( event.getTimestamp() );
        byte[] payload = event.getPayload();
        if ( payload != null ) {
            reportEvent.setPayload( Arrays.copyOf( payload, payload.length ) );
        }
        reportEvent.setEventOrigin( event.getEventOrigin() );
        reportEvent.setEventType( event.getEventType() );
        reportEvent.setInstanceId( event.getInstanceId() );
        reportEvent.setTppAuthorisationNumber( event.getTppAuthorisationNumber() );
        reportEvent.setXRequestId( event.getXRequestId() );
        reportEvent.setInternalRequestId( event.getInternalRequestId() );

        mapToReportEventAfterMappingFromEventEntity( event, reportEvent );

        return reportEvent;
    }

    private String eventConsentExternalId(EventReportEntity eventReportEntity) {
        if ( eventReportEntity == null ) {
            return null;
        }
        EventConsentEntity consent = eventReportEntity.getConsent();
        if ( consent == null ) {
            return null;
        }
        String externalId = consent.getExternalId();
        if ( externalId == null ) {
            return null;
        }
        return externalId;
    }

    private String eventPaymentPaymentId(EventReportEntity eventReportEntity) {
        if ( eventReportEntity == null ) {
            return null;
        }
        EventPaymentEntity payment = eventReportEntity.getPayment();
        if ( payment == null ) {
            return null;
        }
        String paymentId = payment.getPaymentId();
        if ( paymentId == null ) {
            return null;
        }
        return paymentId;
    }
}
