package de.adorsys.psd2.event.service.mapper;

import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.event.service.model.AspspEvent;
import de.adorsys.psd2.event.service.model.AspspEvent.EventBuilder;
import de.adorsys.psd2.event.service.model.AspspPsuIdData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-08-14T08:06:36+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class AspspEventMapperImpl extends AspspEventMapper {

    @Override
    public AspspEvent toAspspEvent(ReportEvent event) {
        if ( event == null ) {
            return null;
        }

        EventBuilder aspspEvent = AspspEvent.builder();

        aspspEvent.xRequestId( mapToXRequestId( event.getXRequestId() ) );
        aspspEvent.psuIdData( psuIdDataPOSetToAspspPsuIdDataList( event.getPsuIdData() ) );
        aspspEvent.internalRequestId( mapToInternalRequestId( event.getInternalRequestId() ) );
        aspspEvent.timestamp( event.getTimestamp() );
        aspspEvent.consentId( event.getConsentId() );
        aspspEvent.paymentId( event.getPaymentId() );
        aspspEvent.payload( mapToPayload( event.getPayload() ) );
        aspspEvent.eventOrigin( event.getEventOrigin() );
        aspspEvent.eventType( event.getEventType() );
        aspspEvent.instanceId( event.getInstanceId() );
        aspspEvent.tppAuthorisationNumber( event.getTppAuthorisationNumber() );

        return aspspEvent.build();
    }

    @Override
    public List<AspspEvent> toAspspEventList(List<ReportEvent> events) {
        if ( events == null ) {
            return new ArrayList<AspspEvent>();
        }

        List<AspspEvent> list = new ArrayList<AspspEvent>( events.size() );
        for ( ReportEvent reportEvent : events ) {
            list.add( toAspspEvent( reportEvent ) );
        }

        return list;
    }

    protected List<AspspPsuIdData> psuIdDataPOSetToAspspPsuIdDataList(Set<PsuIdDataPO> set) {
        if ( set == null ) {
            return null;
        }

        List<AspspPsuIdData> list = new ArrayList<AspspPsuIdData>( set.size() );
        for ( PsuIdDataPO psuIdDataPO : set ) {
            list.add( mapToPduIdData( psuIdDataPO ) );
        }

        return list;
    }
}
