package de.adorsys.psd2.event.service.mapper;

import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.event.service.model.AspspEvent;
import de.adorsys.psd2.event.service.model.AspspEvent.EventBuilder;
import de.adorsys.psd2.event.service.model.AspspPsuIdData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-09-13T09:38:59+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class AspspEventMapperImpl extends AspspEventMapper {

    @Override
    public AspspEvent toAspspEvent(ReportEvent event) {
        if ( event == null ) {
            return null;
        }

        EventBuilder aspspEvent = AspspEvent.builder();

        aspspEvent.xRequestId( mapToXRequestId( event.getXRequestId() ) );
        aspspEvent.psuIdData( psuIdDataPOSetToAspspPsuIdDataList( event.getPsuIdData() ) );
        aspspEvent.internalRequestId( mapToInternalRequestId( event.getInternalRequestId() ) );
        aspspEvent.timestamp( event.getTimestamp() );
        aspspEvent.consentId( event.getConsentId() );
        aspspEvent.paymentId( event.getPaymentId() );
        aspspEvent.eventOrigin( event.getEventOrigin() );
        aspspEvent.eventType( event.getEventType() );
        aspspEvent.instanceId( event.getInstanceId() );
        aspspEvent.tppAuthorisationNumber( event.getTppAuthorisationNumber() );

        aspspEvent.payload( jsonConverterService.toObject(event.getPayload(), Object.class).orElse(null) );

        return aspspEvent.build();
    }

    @Override
    public List<AspspEvent> toAspspEventList(List<ReportEvent> events) {
        if ( events == null ) {
            return new ArrayList<AspspEvent>();
        }

        List<AspspEvent> list = new ArrayList<AspspEvent>( events.size() );
        for ( ReportEvent reportEvent : events ) {
            list.add( toAspspEvent( reportEvent ) );
        }

        return list;
    }

    protected List<AspspPsuIdData> psuIdDataPOSetToAspspPsuIdDataList(Set<PsuIdDataPO> set) {
        if ( set == null ) {
            return null;
        }

        List<AspspPsuIdData> list = new ArrayList<AspspPsuIdData>( set.size() );
        for ( PsuIdDataPO psuIdDataPO : set ) {
            list.add( mapToPduIdData( psuIdDataPO ) );
        }

        return list;
    }
}
