/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.event.service;

import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.event.persist.EventReportRepository;
import de.adorsys.psd2.event.service.AspspEventService;
import de.adorsys.psd2.event.service.mapper.AspspEventMapper;
import de.adorsys.psd2.event.service.model.AspspEvent;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
public class AspspEventServiceImpl
implements AspspEventService {
    private final EventReportRepository eventReportRepository;
    private final AspspEventMapper eventBOMapper;

    public List<AspspEvent> getEventsForPeriod(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        List events = this.eventReportRepository.getEventsForPeriod(start, end, instanceId, pageIndex, itemsPerPage);
        return this.eventBOMapper.toAspspEventList(events);
    }

    public List<AspspEvent> getEventsForPeriodAndConsentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String consentId, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        List result = this.eventReportRepository.getEventsForPeriodAndConsentId(start, end, consentId, instanceId, pageIndex, itemsPerPage);
        return this.eventBOMapper.toAspspEventList(result);
    }

    public List<AspspEvent> getEventsForPeriodAndPaymentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String paymentId, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        List result = this.eventReportRepository.getEventsForPeriodAndPaymentId(start, end, paymentId, instanceId, pageIndex, itemsPerPage);
        return this.eventBOMapper.toAspspEventList(result);
    }

    public List<AspspEvent> getEventsForPeriodAndEventType(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventType eventType, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        List result = this.eventReportRepository.getEventsForPeriodAndEventType(start, end, eventType, instanceId, pageIndex, itemsPerPage);
        return this.eventBOMapper.toAspspEventList(result);
    }

    public List<AspspEvent> getEventsForPeriodAndEventOrigin(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventOrigin eventOrigin, @Nullable String instanceId, @Nullable Integer pageIndex, @Nullable Integer itemsPerPage) {
        List result = this.eventReportRepository.getEventsForPeriodAndEventOrigin(start, end, eventOrigin, instanceId, pageIndex, itemsPerPage);
        return this.eventBOMapper.toAspspEventList(result);
    }

    @ConstructorProperties(value={"eventReportRepository", "eventBOMapper"})
    public AspspEventServiceImpl(EventReportRepository eventReportRepository, AspspEventMapper eventBOMapper) {
        this.eventReportRepository = eventReportRepository;
        this.eventBOMapper = eventBOMapper;
    }
}

