/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.event.service.mapper;

import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.event.service.model.AspspEvent;
import de.adorsys.psd2.event.service.model.AspspPsuIdData;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class AspspEventMapper {
    private static final Logger log = LoggerFactory.getLogger(AspspEventMapper.class);
    @Autowired
    protected Xs2aObjectMapper xs2aObjectMapper;

    @Mappings(value={@Mapping(target="xRequestId", source="XRequestId", qualifiedByName={"mapToXRequestId"}), @Mapping(target="internalRequestId", source="internalRequestId", qualifiedByName={"mapToInternalRequestId"}), @Mapping(target="psuIdData", source="psuIdData", qualifiedByName={"mapToPsuIdDataList"}), @Mapping(target="payload", qualifiedByName={"mapToPayload"})})
    public abstract AspspEvent toAspspEvent(ReportEvent var1);

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    public abstract List<AspspEvent> toAspspEventList(List<ReportEvent> var1);

    @Named(value="mapToPsuIdDataList")
    protected abstract List<AspspPsuIdData> mapToPsuIdDataList(Set<PsuIdDataPO> var1);

    @Named(value="mapToPayload")
    protected Object mapToPayload(byte[] array) {
        try {
            return this.xs2aObjectMapper.readValue(array, Object.class);
        }
        catch (IOException e) {
            log.info("Can't convert json to object: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Named(value="mapToXRequestId")
    protected UUID mapToXRequestId(String xRequestId) {
        return xRequestId != null ? UUID.fromString(xRequestId) : null;
    }

    @Named(value="mapToInternalRequestId")
    protected UUID mapToInternalRequestId(String internalRequestId) {
        return internalRequestId != null ? UUID.fromString(internalRequestId) : null;
    }

    protected AspspPsuIdData mapToPsuIdData(PsuIdDataPO psuIdDataPO) {
        if (psuIdDataPO == null) {
            return null;
        }
        return new AspspPsuIdData(psuIdDataPO.getPsuId(), psuIdDataPO.getPsuIdType(), psuIdDataPO.getPsuCorporateId(), psuIdDataPO.getPsuCorporateIdType());
    }
}

