/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.event.service.mapper;

import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.event.service.mapper.AspspEventMapper;
import de.adorsys.psd2.event.service.model.AspspEvent;
import de.adorsys.psd2.event.service.model.AspspPsuIdData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class AspspEventMapperImpl
extends AspspEventMapper {
    @Override
    public AspspEvent toAspspEvent(ReportEvent event) {
        if (event == null) {
            return null;
        }
        AspspEvent.AspspEventBuilder aspspEvent = AspspEvent.builder();
        aspspEvent.xRequestId(this.mapToXRequestId(event.getXRequestId()));
        aspspEvent.internalRequestId(this.mapToInternalRequestId(event.getInternalRequestId()));
        aspspEvent.psuIdData(this.mapToPsuIdDataList(event.getPsuIdData()));
        aspspEvent.payload(this.mapToPayload(event.getPayload()));
        aspspEvent.timestamp(event.getTimestamp());
        aspspEvent.consentId(event.getConsentId());
        aspspEvent.paymentId(event.getPaymentId());
        aspspEvent.eventOrigin(event.getEventOrigin());
        aspspEvent.eventType(event.getEventType());
        aspspEvent.instanceId(event.getInstanceId());
        aspspEvent.tppAuthorisationNumber(event.getTppAuthorisationNumber());
        return aspspEvent.build();
    }

    @Override
    public List<AspspEvent> toAspspEventList(List<ReportEvent> events) {
        if (events == null) {
            return new ArrayList<AspspEvent>();
        }
        ArrayList<AspspEvent> list = new ArrayList<AspspEvent>(events.size());
        for (ReportEvent reportEvent : events) {
            list.add(this.toAspspEvent(reportEvent));
        }
        return list;
    }

    @Override
    protected List<AspspPsuIdData> mapToPsuIdDataList(Set<PsuIdDataPO> psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        ArrayList<AspspPsuIdData> list = new ArrayList<AspspPsuIdData>(psuIdData.size());
        for (PsuIdDataPO psuIdDataPO : psuIdData) {
            list.add(this.mapToPsuIdData(psuIdDataPO));
        }
        return list;
    }
}

