package de.adorsys.psd2.event.service.mapper;

import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.event.service.model.AspspEvent;
import de.adorsys.psd2.event.service.model.AspspEvent.AspspEventBuilder;
import de.adorsys.psd2.event.service.model.AspspPsuIdData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-08-12T15:58:28+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class AspspEventMapperImpl extends AspspEventMapper {

    @Override
    public AspspEvent toAspspEvent(ReportEvent event) {
        if ( event == null ) {
            return null;
        }

        AspspEventBuilder aspspEvent = AspspEvent.builder();

        aspspEvent.xRequestId( mapToXRequestId( event.getXRequestId() ) );
        aspspEvent.internalRequestId( mapToInternalRequestId( event.getInternalRequestId() ) );
        aspspEvent.psuIdData( mapToPsuIdDataList( event.getPsuIdData() ) );
        aspspEvent.payload( mapToPayload( event.getPayload() ) );
        aspspEvent.timestamp( event.getTimestamp() );
        aspspEvent.consentId( event.getConsentId() );
        aspspEvent.paymentId( event.getPaymentId() );
        aspspEvent.eventOrigin( event.getEventOrigin() );
        aspspEvent.eventType( event.getEventType() );
        aspspEvent.instanceId( event.getInstanceId() );
        aspspEvent.tppAuthorisationNumber( event.getTppAuthorisationNumber() );

        return aspspEvent.build();
    }

    @Override
    public List<AspspEvent> toAspspEventList(List<ReportEvent> events) {
        if ( events == null ) {
            return new ArrayList<AspspEvent>();
        }

        List<AspspEvent> list = new ArrayList<AspspEvent>( events.size() );
        for ( ReportEvent reportEvent : events ) {
            list.add( toAspspEvent( reportEvent ) );
        }

        return list;
    }

    @Override
    protected List<AspspPsuIdData> mapToPsuIdDataList(Set<PsuIdDataPO> psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }

        List<AspspPsuIdData> list = new ArrayList<AspspPsuIdData>( psuIdData.size() );
        for ( PsuIdDataPO psuIdDataPO : psuIdData ) {
            list.add( mapToPsuIdData( psuIdDataPO ) );
        }

        return list;
    }
}
