/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.ais.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(path={"api/v1/consent"})
@Api(value="api/v1/consent", tags={"Consents"})
public interface CmsConsentApi {
    @PostMapping
    @ApiOperation(value="Create new consent")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity<Object> createConsent(@RequestBody CmsConsent var1);

    @GetMapping(path={"/{encrypted-consent-id}"})
    @ApiOperation(value="Read consent by ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CmsConsent.class), @ApiResponse(code=404, message="Not found")})
    public ResponseEntity<CmsConsent> getConsentById(@ApiParam(name="encrypted-consent-id", value="Encrypted consent ID", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="encrypted-consent-id") String var1);

    @GetMapping(path={"/{encrypted-consent-id}/status"})
    @ApiOperation(value="Get consent status by ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConsentStatus.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<ConsentStatusResponse> getConsentStatusById(@ApiParam(name="encrypted-consent-id", value="Encrypted consent ID", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="encrypted-consent-id") String var1);

    @PutMapping(path={"/{encrypted-consent-id}/status/{status}"})
    @ApiOperation(value="Update consent status by ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Object> updateConsentStatus(@ApiParam(name="encrypted-consent-id", value="Encrypted consent ID", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="encrypted-consent-id") String var1, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID", required=true) @PathVariable(value="status") String var2);

    @DeleteMapping(path={"/{encrypted-consent-id}/old-consents"})
    @ApiOperation(value="Find and terminate old consents for TPP and PSU by new consent ID")
    @ApiResponse(code=204, message="No Content")
    public ResponseEntity<Void> findAndTerminateOldConsentsByNewConsentId(@ApiParam(name="encrypted-consent-id", value="Encrypted consent ID", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="encrypted-consent-id") String var1);

    @PutMapping(path={"/{encrypted-consent-id}/multilevel-sca"})
    @ApiOperation(value="Update requirement for multilevel SCA for consent")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Object> updateMultilevelScaRequired(@ApiParam(name="encrypted-consent-id", value="Encrypted consent ID", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="encrypted-consent-id") String var1, @ApiParam(name="multilevel-sca", value="Multilevel SCA.", example="false") @RequestParam(value="multilevel-sca", defaultValue="false") boolean var2);
}

