/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(path={"api/v1/aspsp-consent-data/consents/{consent-id}"})
@Api(value="api/v1/aspsp-consent-data", tags={"Aspsp Consent Data"})
public interface AspspConsentDataApi {
    @GetMapping
    @ApiOperation(value="Get aspsp consent data identified by given consent id / payment id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CmsAspspConsentDataBase64> getAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent / payment identification assigned to the created payment.", example="CxymMkwtykFtTeQuH1jrcoOyzcqCcwNCt5193Gfn33mqqcAy_xw2KPwMd5y6Xxe1EwE0BTNRHeyM0FI90wh0hA==_=_bS6p6XvTWI", required=true) @PathVariable(value="consent-id") String var1);

    @PutMapping
    @ApiOperation(value="Update aspsp consent data identified by given consent id / payment id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> updateAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent / payment identification assigned to the created payment.", example="CxymMkwtykFtTeQuH1jrcoOyzcqCcwNCt5193Gfn33mqqcAy_xw2KPwMd5y6Xxe1EwE0BTNRHeyM0FI90wh0hA==_=_bS6p6XvTWI", required=true) @PathVariable(value="consent-id") String var1, @RequestBody CmsAspspConsentDataBase64 var2);

    @DeleteMapping
    @ApiOperation(value="Delete aspsp consent data identified by given consent id / payment id.")
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> deleteAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent / payment identification assigned to the created payment.", example="CxymMkwtykFtTeQuH1jrcoOyzcqCcwNCt5193Gfn33mqqcAy_xw2KPwMd5y6Xxe1EwE0BTNRHeyM0FI90wh0hA==_=_bS6p6XvTWI", required=true) @PathVariable(value="consent-id") String var1);
}

