/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.PisCommonPaymentDataStatusResponse;
import de.adorsys.psd2.consent.api.pis.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(path={"api/v1/pis/common-payments"})
@Api(value="api/v1/pis/common-payments", tags={"PIS, Common Payment"})
public interface PisCommonPaymentApi {
    @PostMapping(path={"/"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CreatePisCommonPaymentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<CreatePisCommonPaymentResponse> createCommonPayment(@RequestBody PisPaymentInfo var1);

    @GetMapping(path={"/{payment-id}/status"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisCommonPaymentDataStatusResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisCommonPaymentDataStatusResponse> getPisCommonPaymentStatusById(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1);

    @GetMapping(path={"/{payment-id}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisCommonPaymentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisCommonPaymentResponse> getCommonPaymentById(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1);

    @PutMapping(path={"/{payment-id}/status/{status}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateCommonPaymentStatus(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(value="The following code values are permitted 'ACCC', 'ACCP', 'ACSC', 'ACSP', 'ACTC', 'ACWC', 'ACWP', 'PDNG', 'RJCT', 'RCVD', 'CANC', 'ACFC', 'PATC'. These values might be extended by ASPSP by more values.", allowableValues="AcceptedSettlementCompletedCreditor, AcceptedCustomerProfile, AcceptedSettlementCompleted, AcceptedSettlementInProcess, AcceptedTechnicalValidation, AcceptedWithChange, AcceptedWithoutPosting, Received, Pending, Rejected, Canceled, AcceptedFundsChecked, PartiallyAcceptedTechnicalCorrect", required=true) @PathVariable(value="status") String var2);

    @PostMapping(path={"/{payment-id}/authorisations"})
    @ApiOperation(value="Create authorisation for given id.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAuthorisationResponse> createAuthorisation(@ApiParam(name="payment-id", value="The payment identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @RequestBody CreateAuthorisationRequest var2);

    @PostMapping(path={"/{payment-id}/cancellation-authorisations"})
    @ApiOperation(value="Create payment authorisation cancellation for given payment id.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAuthorisationResponse> createAuthorisationCancellation(@ApiParam(name="payment-id", value="The payment identification of the related payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @RequestBody CreateAuthorisationRequest var2);

    @PutMapping(path={"/authorisations/{authorisation-id}"})
    @ApiOperation(value="Update pis authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Authorisation> updateAuthorisation(@ApiParam(name="authorisation-id", value="The authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @RequestBody UpdateAuthorisationRequest var2);

    @PutMapping(path={"authorisations/{authorisation-id}/status/{status}"})
    @ApiOperation(value="Update status for PIS authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateAuthorisationStatus(@ApiParam(name="authorisation-id", value="The authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @ApiParam(name="status", value="The authorisation status.", example="ScaStatus.FAILED", required=true) @PathVariable(value="status") String var2);

    @GetMapping(path={"/authorisations/{authorisation-id}"})
    @ApiOperation(value="Getting pis authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Authorisation> getAuthorisation(@ApiParam(name="authorisation-id", value="The authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1);

    @GetMapping(path={"/{payment-id}/authorisations/{authorisation-id}/status"})
    @ApiOperation(value="Gets SCA status of pis consent authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<ScaStatus> getAuthorisationScaStatus(@ApiParam(name="payment-id", value="Identification of the payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(name="authorisation-id", value="The consent authorisation identification", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var2);

    @PutMapping(path={"/cancellation-authorisations/{authorisation-id}"})
    @ApiOperation(value="Update pis cancellation authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Authorisation> updateCancellationAuthorisation(@ApiParam(name="cancellation-id", value="The cancellation authorisation identification assigned to the created cancellation authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @RequestBody UpdateAuthorisationRequest var2);

    @GetMapping(path={"/cancellation-authorisations/{authorisation-id}"})
    @ApiOperation(value="Getting pis cancellation authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<String>> getAuthorisationCancellation(@ApiParam(name="cancellation-id", value="The cancellation authorisation identification assigned to the created cancellation authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1);

    @GetMapping(path={"/{payment-id}/cancellation-authorisations"})
    @ApiOperation(value="Gets list of payment cancellation authorisation IDs by payment ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<String>> getAuthorisationsCancellation(@ApiParam(name="payment-id", value="The payment identification of the related payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1);

    @GetMapping(path={"/{payment-id}/cancellation-authorisations/{authorisation-id}/status"})
    @ApiOperation(value="Gets SCA status of pis consent cancellation authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<ScaStatus> getCancellationAuthorisationScaStatus(@ApiParam(name="payment-id", value="Identification of the payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(name="cancellation-id", value="Identification of the consent cancellation authorisation", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var2);

    @GetMapping(path={"/{payment-id}/authorisations"})
    @ApiOperation(value="Gets list of payment authorisation IDs by payment ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<String>> getAuthorisations(@ApiParam(name="payment-id", value="The payment identification of the related payment.", example="vOHy6fj2f5IgxHk-kTlhw6sZdTXbRE3bWsu2obq54beYOChP5NvRmfh06nrwumc2R01HygQenchEcdGOlU-U0A==_=_iR74m2PdNyE", required=true) @PathVariable(value="payment-id") String var1);

    @GetMapping(path={"/authorisations/{authorisation-id}/authentication-methods/{authentication-method-id}"})
    @ApiOperation(value="Checks if requested authentication method is decoupled")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> isAuthenticationMethodDecoupled(@ApiParam(name="authorisation-id", value="Common payment authorisation identification", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @ApiParam(name="authentication-method-id", value="Authentication method identification", example="sms", required=true) @PathVariable(value="authentication-method-id") String var2);

    @PostMapping(path={"/authorisations/{authorisation-id}/authentication-methods"})
    @ApiOperation(value="Saves authentication methods in authorisation")
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> saveAuthenticationMethods(@ApiParam(name="authorisation-id", value="The common payment authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @RequestBody List<CmsScaMethod> var2);

    @PutMapping(path={"/authorisations/{authorisation-id}/sca-approach/{sca-approach}"})
    @ApiOperation(value="Updates pis sca approach.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> updateScaApproach(@ApiParam(name="authorisation-id", value="The authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @ApiParam(name="sca-approach", value="Chosen SCA approach.", example="REDIRECT", required=true) @PathVariable(value="sca-approach") ScaApproach var2);

    @GetMapping(path={"/authorisations/{authorisation-id}/sca-approach"})
    @ApiOperation(value="Gets SCA approach of the payment initiation authorisation by its ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AuthorisationScaApproachResponse> getAuthorisationScaApproach(@ApiParam(name="authorisation-id", value="Identification of the payment initiation authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1);

    @GetMapping(path={"/cancellation-authorisations/{authorisation-id}/sca-approach"})
    @ApiOperation(value="Gets SCA approach of the payment cancellation authorisation by its ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AuthorisationScaApproachResponse> getCancellationAuthorisationScaApproach(@ApiParam(name="authorisation-id", value="Identification of the payment cancellation authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1);

    @PutMapping(path={"/{payment-id}/multilevel-sca"})
    @ApiOperation(value="Updates multilevel sca required by payment ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Bad Request")})
    public ResponseEntity<Boolean> updateMultilevelScaRequired(@ApiParam(name="payment-id", value="The payment identification of the related payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(name="payment-id") String var1, @ApiParam(name="multilevel-sca", value="Multilevel SCA.", example="false") @RequestParam(value="multilevel-sca", defaultValue="false") boolean var2);
}

