/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(path={"api/v1/pis"})
@Api(value="api/v1/pis", tags={"PIS, Payments"})
public interface PisPaymentApi {
    @GetMapping(path={"/payment/{payment-id}"})
    @ApiOperation(value="Get inner payment id by encrypted string")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<String> getPaymentIdByEncryptedString(@ApiParam(name="payment-id", value="The payment identification.", example="32454656712432", required=true) @PathVariable(value="payment-id") String var1);

    @PutMapping(path={"/payment/{payment-id}/status/{status}"})
    @ApiOperation(value="Updates payment status after SPI service. Should not be used for any other purposes!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePaymentStatusAfterSpiService(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(value="The following code values are permitted 'ACCC', 'ACCP', 'ACSC', 'ACSP', 'ACTC', 'ACWC', 'ACWP', 'PDNG', 'RJCT', 'RCVD', 'CANC', 'ACFC', 'PATC'. These values might be extended by ASPSP by more values.", allowableValues="ACCC, ACCP, ACSC, ACSP, ACTC, ACWC, ACWP, RCVD, PDNG, RJCT, CANC, ACFC, PATC", required=true) @PathVariable(value="status") String var2);

    @PutMapping(path={"/payment/{payment-id}/cancellation/redirects"})
    @ApiOperation(value="Updates payment cancellation redirect URIs after SPI service. Should not be used for any other purposes!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePaymentCancellationTppRedirectUri(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", required=true) @PathVariable(value="payment-id") String var1, @RequestHeader(value="TPP-Redirect-URI", required=false) String var2, @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String var3);

    @PutMapping(path={"/payment/{payment-id}/cancellation/internal-request-id/{internal-request-id}"})
    @ApiOperation(value="Updates payment cancellation internal request ID after SPI service. Should not be used for any other purposes!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePaymentCancellationInternalRequestId(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(name="internal-request-id", value="Cancellation internal request ID of payment.", required=true) @PathVariable(value="internal-request-id") String var2);
}

