/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.consent.api.CmsError;
import org.jetbrains.annotations.NotNull;

public final class CmsResponse<T> {
    private static final VoidResponse VOID_RESPONSE = new VoidResponse();
    private final T payload;
    private final CmsError error;

    private CmsResponse(CmsResponseBuilder<T> builder) {
        this.payload = ((CmsResponseBuilder)builder).payload;
        this.error = ((CmsResponseBuilder)builder).error;
    }

    public static VoidResponse voidResponse() {
        return VOID_RESPONSE;
    }

    public static <T> CmsResponseBuilder<T> builder() {
        return new CmsResponseBuilder();
    }

    public boolean hasError() {
        return this.error != null || this.payload == null;
    }

    public boolean isSuccessful() {
        return this.error == null && this.payload != null;
    }

    public T getPayload() {
        return this.payload;
    }

    public CmsError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CmsResponse)) {
            return false;
        }
        CmsResponse other = (CmsResponse)o;
        T this$payload = this.getPayload();
        T other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        CmsError this$error = this.getError();
        CmsError other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        CmsError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "CmsResponse(payload=" + this.getPayload() + ", error=" + this.getError() + ")";
    }

    public static class VoidResponse {
        private VoidResponse() {
        }
    }

    public static class CmsResponseBuilder<T> {
        private T payload;
        private CmsError error;

        private CmsResponseBuilder() {
        }

        public CmsResponseBuilder<T> payload(T payload) {
            this.payload = payload;
            return this;
        }

        public CmsResponseBuilder<T> error(@NotNull CmsError error) {
            this.error = error;
            return this;
        }

        public CmsResponse<T> build() {
            if (this.payload == null && this.error == null) {
                this.error = CmsError.TECHNICAL_ERROR;
            }
            return new CmsResponse(this);
        }
    }
}

