/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.pis.proto;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

public class PisPaymentInfo {
    @ApiModelProperty(value="External Payment Id", example="32454656712432")
    private String paymentId;
    @ApiModelProperty(value="Payment product", required=true, example="sepa-credit-transfers")
    private String paymentProduct;
    @ApiModelProperty(value="Payment type: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PaymentType paymentType;
    @ApiModelProperty(name="transactionStatus", example="ACCP")
    private TransactionStatus transactionStatus;
    @ApiModelProperty(value="Payment data")
    private byte[] paymentData;
    @ApiModelProperty(value="Tpp information", required=true)
    private TppInfo tppInfo;
    @ApiModelProperty(value="Corresponding PSU list", required=true)
    private List<PsuIdData> psuDataList;
    @ApiModelProperty(value="Defines whether the payment requires multilevel SCA", example="true")
    private boolean multilevelScaRequired;
    @ApiModelProperty(value="Aspsp-Account-ID: Bank specific account ID", example="26bb59a3-2f63-4027-ad38-67d87e59611a")
    private String aspspAccountId;
    @ApiModelProperty(value="Timestamp of the last payment transaction status changing")
    private OffsetDateTime statusChangeTimestamp;
    @ApiModelProperty(value="Tpp redirect URI object'")
    private TppRedirectUri tppRedirectUri;

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public byte[] getPaymentData() {
        return this.paymentData;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public List<PsuIdData> getPsuDataList() {
        return this.psuDataList;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public TppRedirectUri getTppRedirectUri() {
        return this.tppRedirectUri;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setPaymentData(byte[] paymentData) {
        this.paymentData = paymentData;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setPsuDataList(List<PsuIdData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setTppRedirectUri(TppRedirectUri tppRedirectUri) {
        this.tppRedirectUri = tppRedirectUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisPaymentInfo)) {
            return false;
        }
        PisPaymentInfo other = (PisPaymentInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        if (!Arrays.equals(this.getPaymentData(), other.getPaymentData())) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        List<PsuIdData> this$psuDataList = this.getPsuDataList();
        List<PsuIdData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        if (this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        TppRedirectUri this$tppRedirectUri = this.getTppRedirectUri();
        TppRedirectUri other$tppRedirectUri = other.getTppRedirectUri();
        return !(this$tppRedirectUri == null ? other$tppRedirectUri != null : !this$tppRedirectUri.equals(other$tppRedirectUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisPaymentInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPaymentData());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        List<PsuIdData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        TppRedirectUri $tppRedirectUri = this.getTppRedirectUri();
        result = result * 59 + ($tppRedirectUri == null ? 43 : $tppRedirectUri.hashCode());
        return result;
    }

    public String toString() {
        return "PisPaymentInfo(paymentId=" + this.getPaymentId() + ", paymentProduct=" + this.getPaymentProduct() + ", paymentType=" + this.getPaymentType() + ", transactionStatus=" + this.getTransactionStatus() + ", paymentData=" + Arrays.toString(this.getPaymentData()) + ", tppInfo=" + this.getTppInfo() + ", psuDataList=" + this.getPsuDataList() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", aspspAccountId=" + this.getAspspAccountId() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", tppRedirectUri=" + this.getTppRedirectUri() + ")";
    }
}

