/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.ais;

import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;

@ApiModel(description="Ais consent request", value="AisConsentRequest")
public class CreateAisConsentRequest {
    @ApiModelProperty(value="Corresponding PSU", required=true)
    private PsuIdData psuData;
    @ApiModelProperty(value="Tpp information", required=true)
    private TppInfo tppInfo;
    @ApiModelProperty(value="Allowed maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private Integer allowedFrequencyPerDay;
    @ApiModelProperty(value="Requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int requestedFrequencyPerDay;
    @ApiModelProperty(value="Set of accesses given by psu for this account", required=true)
    private AisAccountAccessInfo access;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", required=true, example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.", example="true")
    private boolean tppRedirectPreferred;
    @ApiModelProperty(value="If 'true' indicates that a payment initiation service will be addressed in the same 'session'", required=true, example="false")
    private boolean combinedServiceIndicator;
    @ApiModelProperty(value="TPP redirect URI object'")
    private TppRedirectUri tppRedirectUri;
    @ApiModelProperty(value="Internal request ID")
    private String internalRequestId;

    public PsuIdData getPsuData() {
        return this.psuData;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public Integer getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public int getRequestedFrequencyPerDay() {
        return this.requestedFrequencyPerDay;
    }

    public AisAccountAccessInfo getAccess() {
        return this.access;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public TppRedirectUri getTppRedirectUri() {
        return this.tppRedirectUri;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public void setPsuData(PsuIdData psuData) {
        this.psuData = psuData;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAllowedFrequencyPerDay(Integer allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public void setRequestedFrequencyPerDay(int requestedFrequencyPerDay) {
        this.requestedFrequencyPerDay = requestedFrequencyPerDay;
    }

    public void setAccess(AisAccountAccessInfo access) {
        this.access = access;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setTppRedirectUri(TppRedirectUri tppRedirectUri) {
        this.tppRedirectUri = tppRedirectUri;
    }

    public void setInternalRequestId(String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAisConsentRequest)) {
            return false;
        }
        CreateAisConsentRequest other = (CreateAisConsentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PsuIdData this$psuData = this.getPsuData();
        PsuIdData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !this$psuData.equals(other$psuData)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        Integer this$allowedFrequencyPerDay = this.getAllowedFrequencyPerDay();
        Integer other$allowedFrequencyPerDay = other.getAllowedFrequencyPerDay();
        if (this$allowedFrequencyPerDay == null ? other$allowedFrequencyPerDay != null : !((Object)this$allowedFrequencyPerDay).equals(other$allowedFrequencyPerDay)) {
            return false;
        }
        if (this.getRequestedFrequencyPerDay() != other.getRequestedFrequencyPerDay()) {
            return false;
        }
        AisAccountAccessInfo this$access = this.getAccess();
        AisAccountAccessInfo other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        TppRedirectUri this$tppRedirectUri = this.getTppRedirectUri();
        TppRedirectUri other$tppRedirectUri = other.getTppRedirectUri();
        if (this$tppRedirectUri == null ? other$tppRedirectUri != null : !this$tppRedirectUri.equals(other$tppRedirectUri)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        return !(this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateAisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PsuIdData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : $psuData.hashCode());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        Integer $allowedFrequencyPerDay = this.getAllowedFrequencyPerDay();
        result = result * 59 + ($allowedFrequencyPerDay == null ? 43 : ((Object)$allowedFrequencyPerDay).hashCode());
        result = result * 59 + this.getRequestedFrequencyPerDay();
        AisAccountAccessInfo $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        TppRedirectUri $tppRedirectUri = this.getTppRedirectUri();
        result = result * 59 + ($tppRedirectUri == null ? 43 : $tppRedirectUri.hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateAisConsentRequest(psuData=" + this.getPsuData() + ", tppInfo=" + this.getTppInfo() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ", requestedFrequencyPerDay=" + this.getRequestedFrequencyPerDay() + ", access=" + this.getAccess() + ", validUntil=" + this.getValidUntil() + ", recurringIndicator=" + this.isRecurringIndicator() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", tppRedirectUri=" + this.getTppRedirectUri() + ", internalRequestId=" + this.getInternalRequestId() + ")";
    }
}

