/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Account information", value="AccountInfo")
public class AccountInfo {
    @ApiModelProperty(value="RESOURCE-ID: This identification is denoting the addressed account.")
    private String resourceId;
    @ApiModelProperty(value="Aspsp-Account-ID: Bank specific account ID", example="26bb59a3-2f63-4027-ad38-67d87e59611a")
    private String aspspAccountId;
    @ApiModelProperty(value="Account-Identifier: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", example="DE2310010010123456789")
    private String accountIdentifier;
    @ApiModelProperty(value="ISO 4217 currency code", example="EUR")
    private String currency;
    @ApiModelProperty(value="Type of the account reference: IBAN, BBAN, IBAN, BBAN, PAN, MASKED_PAN, MSISDN", required=true, example="IBAN")
    private AccountReferenceType accountType;

    private AccountInfo() {
    }

    public static AccountInfoBuilder builder() {
        return new AccountInfoBuilder();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public String getCurrency() {
        return this.currency;
    }

    public AccountReferenceType getAccountType() {
        return this.accountType;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setAccountType(AccountReferenceType accountType) {
        this.accountType = accountType;
    }

    public static final class AccountInfoBuilder {
        private String resourceId;
        private String aspspAccountId;
        private String accountIdentifier;
        private String currency;
        private AccountReferenceType accountReferenceType;

        private AccountInfoBuilder() {
        }

        public AccountInfoBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public AccountInfoBuilder aspspAccountId(String aspspAccountId) {
            this.aspspAccountId = aspspAccountId;
            return this;
        }

        public AccountInfoBuilder accountIdentifier(String accountIdentifier) {
            this.accountIdentifier = accountIdentifier;
            return this;
        }

        public AccountInfoBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public AccountInfoBuilder accountReferenceType(AccountReferenceType accountReferenceType) {
            this.accountReferenceType = accountReferenceType;
            return this;
        }

        public AccountInfo build() {
            AccountInfo accountInfo = new AccountInfo();
            accountInfo.setResourceId(this.resourceId);
            accountInfo.setAspspAccountId(this.aspspAccountId);
            accountInfo.setAccountIdentifier(this.accountIdentifier);
            accountInfo.setCurrency(this.currency);
            accountInfo.setAccountType(this.accountReferenceType);
            return accountInfo;
        }
    }
}

