/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.pis.proto;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

@ApiModel(description="Pis payment initialisation common payment response", value="PisCommonPaymentResponse")
public class PisCommonPaymentResponse {
    @ApiModelProperty(value="Payment data", required=true)
    private List<PisPayment> payments;
    @ApiModelProperty(value="Payment product", required=true, example="sepa-credit-transfers")
    private String paymentProduct;
    @ApiModelProperty(value="Payment type: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PaymentType paymentType;
    @ApiModelProperty(value="Tpp information", required=true)
    private TppInfo tppInfo;
    @ApiModelProperty(value="An external exposed identification of the created common payment", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @ApiModelProperty(value="List of corresponding PSU", required=true)
    private List<PsuIdData> psuData;
    @ApiModelProperty(value="Payment info")
    private byte[] paymentData;
    @ApiModelProperty(value="Transaction status", required=true)
    private TransactionStatus transactionStatus;
    @ApiModelProperty(value="Timestamp of the last payment transaction status changing")
    private OffsetDateTime statusChangeTimestamp;

    public List<PisPayment> getPayments() {
        return this.payments;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public List<PsuIdData> getPsuData() {
        return this.psuData;
    }

    public byte[] getPaymentData() {
        return this.paymentData;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public void setPayments(List<PisPayment> payments) {
        this.payments = payments;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPsuData(List<PsuIdData> psuData) {
        this.psuData = psuData;
    }

    public void setPaymentData(byte[] paymentData) {
        this.paymentData = paymentData;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisCommonPaymentResponse)) {
            return false;
        }
        PisCommonPaymentResponse other = (PisCommonPaymentResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PisPayment> this$payments = this.getPayments();
        List<PisPayment> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        List<PsuIdData> this$psuData = this.getPsuData();
        List<PsuIdData> other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        if (!Arrays.equals(this.getPaymentData(), other.getPaymentData())) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        return !(this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisCommonPaymentResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PisPayment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        List<PsuIdData> $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPaymentData());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        return result;
    }

    public String toString() {
        return "PisCommonPaymentResponse(payments=" + this.getPayments() + ", paymentProduct=" + this.getPaymentProduct() + ", paymentType=" + this.getPaymentType() + ", tppInfo=" + this.getTppInfo() + ", externalId=" + this.getExternalId() + ", psuData=" + this.getPsuData() + ", paymentData=" + Arrays.toString(this.getPaymentData()) + ", transactionStatus=" + this.getTransactionStatus() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ")";
    }
}

