/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.PisCommonPaymentDataStatusResponse;
import de.adorsys.psd2.consent.api.pis.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(path={"api/v1/pis/common-payments"})
@Api(value="api/v1/pis/common-payments", tags={"PIS, Common Payment"})
public interface PisCommonPaymentApi {
    @PostMapping(path={"/"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CreatePisCommonPaymentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<CreatePisCommonPaymentResponse> createCommonPayment(@RequestBody PisPaymentInfo var1);

    @GetMapping(path={"/{payment-id}/status"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisCommonPaymentDataStatusResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisCommonPaymentDataStatusResponse> getPisCommonPaymentStatusById(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1);

    @GetMapping(path={"/{payment-id}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PisCommonPaymentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<PisCommonPaymentResponse> getCommonPaymentById(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1);

    @PutMapping(path={"/{payment-id}/status/{status}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateCommonPaymentStatus(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(value="The following code values are permitted 'ACCC', 'ACCP', 'ACSC', 'ACSP', 'ACTC', 'ACWC', 'ACWP', 'PDNG', 'RJCT', 'RCVD', 'CANC', 'ACFC', 'PATC'. These values might be extended by ASPSP by more values.", allowableValues="AcceptedSettlementCompletedCreditor, AcceptedCustomerProfile, AcceptedSettlementCompleted, AcceptedSettlementInProcess, AcceptedTechnicalValidation, AcceptedWithChange, AcceptedWithoutPosting, Received, Pending, Rejected, Canceled, AcceptedFundsChecked, PartiallyAcceptedTechnicalCorrect", required=true) @PathVariable(value="status") String var2);

    @PutMapping(path={"/{payment-id}/multilevel-sca"})
    @ApiOperation(value="Updates multilevel sca required by payment ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Bad Request")})
    public ResponseEntity<Boolean> updateMultilevelScaRequired(@ApiParam(name="payment-id", value="The payment identification of the related payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(name="payment-id") String var1, @ApiParam(name="multilevel-sca", value="Multilevel SCA.", example="false") @RequestParam(value="multilevel-sca", defaultValue="false") boolean var2);
}

