/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api;

import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(path={"api/v1/"})
@Api(value="api/v1/", tags={"Authorisations"})
public interface AuthorisationApi {
    @PostMapping(path={"/{authorisation-type}/{parent-id}/authorisations"})
    @ApiOperation(value="Create consent authorization for given consent id.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAuthorisationResponse> createConsentAuthorisation(@PathVariable(value="authorisation-type") AuthorisationType var1, @PathVariable(value="parent-id") String var2, @RequestBody CreateAuthorisationRequest var3);

    @GetMapping(path={"/authorisations/{authorisation-id}"})
    @ApiOperation(value="Getting consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Authorisation> getAuthorisation(@ApiParam(name="authorisation-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1);

    @PutMapping(path={"/authorisations/{authorisation-id}"})
    @ApiOperation(value="Update consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateAuthorisation(@ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @RequestBody UpdateAuthorisationRequest var2);

    @PutMapping(path={"/authorisations/{authorisation-id}/status/{status}"})
    @ApiOperation(value="Update consent authorisation status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateAuthorisationStatus(@ApiParam(name="authorisation-id", value="The consent authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID", required=true) @PathVariable(value="status") String var2);

    @GetMapping(path={"/{authorisation-type}/{parent-id}/authorisations/{authorisation-id}/status"})
    @ApiOperation(value="Gets SCA status of consent authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<ScaStatus> getAuthorisationScaStatus(@PathVariable(value="authorisation-type") AuthorisationType var1, @PathVariable(value="parent-id") String var2, @PathVariable(value="authorisation-id") String var3);

    @GetMapping(path={"/{authorisation-type}/{parent-id}/authorisations"})
    @ApiOperation(value="Gets list of consent authorisation IDs by consent ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<String>> getAuthorisationsByParentId(@PathVariable(value="authorisation-type") AuthorisationType var1, @PathVariable(value="parent-id") String var2);

    @GetMapping(path={"/authorisations/{authorisation-id}/authentication-methods/{authentication-method-id}"})
    @ApiOperation(value="Checks if requested authentication method is decoupled")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> isAuthenticationMethodDecoupled(@ApiParam(name="authorisation-id", value="Consent authorisation identification", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @ApiParam(name="authentication-method-id", value="Authentication method identification", example="sms", required=true) @PathVariable(value="authentication-method-id") String var2);

    @PostMapping(path={"/authorisations/{authorisation-id}/authentication-methods"})
    @ApiOperation(value="Saves authentication methods in authorisation")
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> saveAuthenticationMethods(@ApiParam(name="authorisation-id", value="The consent authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @RequestBody List<CmsScaMethod> var2);

    @PutMapping(path={"/authorisations/{authorisation-id}/sca-approach/{sca-approach}"})
    @ApiOperation(value="Updates AIS SCA approach in authorisation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> updateScaApproach(@ApiParam(name="authorisation-id", value="The consent authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1, @ApiParam(name="sca-approach", value="Chosen SCA approach.", example="REDIRECT", required=true) @PathVariable(value="sca-approach") ScaApproach var2);

    @GetMapping(path={"/authorisations/{authorisation-id}/sca-approach"})
    @ApiOperation(value="Gets SCA approach of the consent authorisation by its ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AuthorisationScaApproachResponse> getAuthorisationScaApproach(@ApiParam(name="authorisation-id", value="The consent authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String var1);
}

