/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.ais;

import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;

@ApiModel(description="Ais consent request", value="AisConsentRequest")
public class CreateAisConsentRequest {
    @ApiModelProperty(value="Corresponding PSU", required=true)
    private PsuIdData psuData;
    @ApiModelProperty(value="ID of the corresponding TPP.", required=true, example="testTPP")
    private String tppId;
    @ApiModelProperty(value="Allowed maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int allowedFrequencyPerDay;
    @ApiModelProperty(value="Requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int requestedFrequencyPerDay;
    @ApiModelProperty(value="Set of accesses given by psu for this account", required=true)
    private AisAccountAccessInfo access;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", required=true, example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.", example="true")
    private boolean tppRedirectPreferred;
    @ApiModelProperty(value="If 'true' indicates that a payment initiation service will be addressed in the same 'session'", required=true, example="false")
    private boolean combinedServiceIndicator;

    public PsuIdData getPsuData() {
        return this.psuData;
    }

    public String getTppId() {
        return this.tppId;
    }

    public int getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public int getRequestedFrequencyPerDay() {
        return this.requestedFrequencyPerDay;
    }

    public AisAccountAccessInfo getAccess() {
        return this.access;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public void setPsuData(PsuIdData psuData) {
        this.psuData = psuData;
    }

    public void setTppId(String tppId) {
        this.tppId = tppId;
    }

    public void setAllowedFrequencyPerDay(int allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public void setRequestedFrequencyPerDay(int requestedFrequencyPerDay) {
        this.requestedFrequencyPerDay = requestedFrequencyPerDay;
    }

    public void setAccess(AisAccountAccessInfo access) {
        this.access = access;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAisConsentRequest)) {
            return false;
        }
        CreateAisConsentRequest other = (CreateAisConsentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PsuIdData this$psuData = this.getPsuData();
        PsuIdData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !this$psuData.equals(other$psuData)) {
            return false;
        }
        String this$tppId = this.getTppId();
        String other$tppId = other.getTppId();
        if (this$tppId == null ? other$tppId != null : !this$tppId.equals(other$tppId)) {
            return false;
        }
        if (this.getAllowedFrequencyPerDay() != other.getAllowedFrequencyPerDay()) {
            return false;
        }
        if (this.getRequestedFrequencyPerDay() != other.getRequestedFrequencyPerDay()) {
            return false;
        }
        AisAccountAccessInfo this$access = this.getAccess();
        AisAccountAccessInfo other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        return this.isCombinedServiceIndicator() == other.isCombinedServiceIndicator();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateAisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PsuIdData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : $psuData.hashCode());
        String $tppId = this.getTppId();
        result = result * 59 + ($tppId == null ? 43 : $tppId.hashCode());
        result = result * 59 + this.getAllowedFrequencyPerDay();
        result = result * 59 + this.getRequestedFrequencyPerDay();
        AisAccountAccessInfo $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CreateAisConsentRequest(psuData=" + this.getPsuData() + ", tppId=" + this.getTppId() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ", requestedFrequencyPerDay=" + this.getRequestedFrequencyPerDay() + ", access=" + this.getAccess() + ", validUntil=" + this.getValidUntil() + ", recurringIndicator=" + this.isRecurringIndicator() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ")";
    }
}

