/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.psu.api.AspspConsentDataPsuApi;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AspspConsentDataPsuApiController
implements AspspConsentDataPsuApi {
    private final AspspDataService aspspDataService;

    public ResponseEntity<CmsAspspConsentDataBase64> getAspspConsentData(String encryptedConsentId) {
        return this.aspspDataService.readAspspConsentData(encryptedConsentId).map(AspspConsentData::getAspspConsentData).map(Base64.getEncoder()::encodeToString).map(aspspConsentDataBase64 -> new CmsAspspConsentDataBase64(encryptedConsentId, aspspConsentDataBase64)).map(cmsAspspConsentDataBase64 -> new ResponseEntity(cmsAspspConsentDataBase64, HttpStatus.OK)).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.notFound()).build());
    }

    public ResponseEntity<Void> updateAspspConsentData(String encryptedConsentId, CmsAspspConsentDataBase64 request) {
        byte[] data = Optional.ofNullable(request.getAspspConsentDataBase64()).map(Base64.getDecoder()::decode).orElse(null);
        AspspConsentData aspspConsentData = new AspspConsentData(data, encryptedConsentId);
        boolean updated = this.aspspDataService.updateAspspConsentData(aspspConsentData);
        if (!updated) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<Void> deleteAspspConsentData(String encryptedConsentId) {
        boolean deleted = this.aspspDataService.deleteAspspConsentData(encryptedConsentId);
        if (!deleted) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.noContent().build();
    }

    @ConstructorProperties(value={"aspspDataService"})
    public AspspConsentDataPsuApiController(AspspDataService aspspDataService) {
        this.aspspDataService = aspspDataService;
    }
}

