/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.piis.v2.CmsConfirmationOfFundsConsent;
import de.adorsys.psd2.consent.api.piis.v2.CmsConfirmationOfFundsResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuConfirmationOfFundsApi;
import de.adorsys.psd2.consent.psu.api.CmsPsuConfirmationOfFundsService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsPsuConfirmationOfFundsController
implements CmsPsuConfirmationOfFundsApi {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuConfirmationOfFundsController.class);
    private final CmsPsuConfirmationOfFundsService cmsPsuConfirmationOfFundsService;

    public ResponseEntity<Object> updateAuthorisationStatus(String consentId, String status, String authorisationId, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, AuthenticationDataHolder authenticationDataHolder) {
        ScaStatus scaStatus = ScaStatus.fromValue((String)status);
        if (scaStatus == null) {
            log.info("Consent ID [{}], Authorisation ID [{}], Instance ID: [{}]. Bad request: SCA status [{}] incorrect.", new Object[]{consentId, authorisationId, instanceId, status});
            return ResponseEntity.badRequest().build();
        }
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        try {
            return this.cmsPsuConfirmationOfFundsService.updateAuthorisationStatus(psuIdData, consentId, authorisationId, scaStatus, instanceId, authenticationDataHolder) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
        }
        catch (AuthorisationIsExpiredException e) {
            log.debug("Consent ID [{}], Authorisation ID [{}], Instance ID: [{}]. Update authorisation status request timeout (authorisation is expired): NOK redirect url [{}]", new Object[]{consentId, authorisationId, instanceId, e.getNokRedirectUri()});
            return new ResponseEntity((Object)new CmsConfirmationOfFundsResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<CmsConfirmationOfFundsResponse> getConsentByRedirectId(String redirectId, String instanceId) {
        try {
            Optional response = this.cmsPsuConfirmationOfFundsService.checkRedirectAndGetConsent(redirectId, instanceId);
            if (response.isEmpty()) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            CmsConfirmationOfFundsResponse cmsConfirmationOfFundsResponse = (CmsConfirmationOfFundsResponse)response.get();
            return new ResponseEntity((Object)cmsConfirmationOfFundsResponse, HttpStatus.OK);
        }
        catch (RedirectUrlIsExpiredException e) {
            log.debug("Redirect ID [{}], Instance ID: [{}]. Get consent ID by redirect ID request timeout (redirect url is expired): NOK redirect url [{}]", new Object[]{redirectId, instanceId, e.getNokRedirectUri()});
            return new ResponseEntity((Object)new CmsConfirmationOfFundsResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<Object> updatePsuDataInConsent(String consentId, String authorisationId, String instanceId, PsuIdData psuIdData) {
        try {
            return this.cmsPsuConfirmationOfFundsService.updatePsuDataInConsent(psuIdData, authorisationId, instanceId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
        }
        catch (AuthorisationIsExpiredException e) {
            log.debug("Consent ID [{}], Authorisation ID [{}], Instance ID: [{}]. Update PSU data request timeout (authorisation is expired): NOK redirect url [{}]", new Object[]{consentId, authorisationId, instanceId, e.getNokRedirectUri()});
            return new ResponseEntity((Object)new CmsConfirmationOfFundsResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity getAuthorisationByAuthorisationId(String authorisationId, String instanceId) {
        try {
            return this.cmsPsuConfirmationOfFundsService.getAuthorisationByAuthorisationId(authorisationId, instanceId).map(authorisation -> new ResponseEntity(authorisation, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
        }
        catch (AuthorisationIsExpiredException e) {
            log.debug("Authorisation ID [{}], Instance ID: [{}]. Get authorisation by authorisation ID request timeout (authorisation is expired): NOK redirect url [{}]", new Object[]{authorisationId, instanceId, e.getNokRedirectUri()});
            return new ResponseEntity((Object)new CmsConfirmationOfFundsResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<Void> updateConsentStatus(String consentId, String status, String instanceId) {
        ConsentStatus consentStatus;
        try {
            consentStatus = ConsentStatus.valueOf((String)status);
        }
        catch (IllegalArgumentException exception) {
            log.info("Consent ID [{}], Instance ID: [{}]. Bad request: SCA status [{}] incorrect.", new Object[]{consentId, instanceId, status});
            return ResponseEntity.badRequest().build();
        }
        return this.cmsPsuConfirmationOfFundsService.updateConsentStatus(consentId, consentStatus, instanceId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    public ResponseEntity<CmsConfirmationOfFundsConsent> getConsentByConsentId(String consentId, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        return this.cmsPsuConfirmationOfFundsService.getConsent(psuIdData, consentId, instanceId).map(consent -> new ResponseEntity(consent, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @ConstructorProperties(value={"cmsPsuConfirmationOfFundsService"})
    public CmsPsuConfirmationOfFundsController(CmsPsuConfirmationOfFundsService cmsPsuConfirmationOfFundsService) {
        this.cmsPsuConfirmationOfFundsService = cmsPsuConfirmationOfFundsService;
    }
}

