/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisApi;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.consent.psu.api.pis.CmsPisPsuDataAuthorisation;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsPsuPisController
implements CmsPsuPisApi {
    private final CmsPsuPisService cmsPsuPisService;

    public ResponseEntity<Object> updatePsuInPayment(String authorisationId, String instanceId, PsuIdData psuIdData) {
        try {
            return this.cmsPsuPisService.updatePsuInPayment(psuIdData, authorisationId, instanceId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
        }
        catch (AuthorisationIsExpiredException e) {
            return new ResponseEntity((Object)new CmsPaymentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<Object> getPaymentIdByRedirectId(String redirectId, String instanceId) {
        try {
            Optional response = this.cmsPsuPisService.checkRedirectAndGetPayment(redirectId, instanceId);
            if (!response.isPresent()) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            CmsPaymentResponse cmsPaymentResponse = (CmsPaymentResponse)response.get();
            return new ResponseEntity((Object)cmsPaymentResponse, HttpStatus.OK);
        }
        catch (RedirectUrlIsExpiredException e) {
            return new ResponseEntity((Object)new CmsPaymentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<CmsPayment> getPaymentByPaymentId(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String paymentId, String instanceId) {
        return this.getPaymentById(psuId, psuIdType, psuCorporateId, psuCorporateIdType, paymentId, instanceId);
    }

    public ResponseEntity<Object> getPaymentIdByRedirectIdForCancellation(String redirectId, String instanceId) {
        try {
            Optional response = this.cmsPsuPisService.checkRedirectAndGetPaymentForCancellation(redirectId, instanceId);
            if (!response.isPresent()) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            CmsPaymentResponse cmsPaymentResponse = (CmsPaymentResponse)response.get();
            return new ResponseEntity((Object)cmsPaymentResponse, HttpStatus.OK);
        }
        catch (RedirectUrlIsExpiredException e) {
            return new ResponseEntity((Object)new CmsPaymentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<CmsPayment> getPaymentByPaymentIdForCancellation(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String paymentId, String instanceId) {
        return this.getPaymentById(psuId, psuIdType, psuCorporateId, psuCorporateIdType, paymentId, instanceId);
    }

    public ResponseEntity<CmsPsuAuthorisation> getAuthorisationByAuthorisationId(String authorisationId, String instanceId) {
        return this.cmsPsuPisService.getAuthorisationByAuthorisationId(authorisationId, instanceId).map(payment -> new ResponseEntity(payment, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    public ResponseEntity<Object> updateAuthorisationStatus(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String paymentId, String authorisationId, String status, String instanceId, AuthenticationDataHolder authenticationDataHolder) {
        ScaStatus scaStatus = ScaStatus.fromValue((String)status);
        if (scaStatus == null) {
            return ResponseEntity.badRequest().build();
        }
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        try {
            return this.cmsPsuPisService.updateAuthorisationStatus(psuIdData, paymentId, authorisationId, scaStatus, instanceId, authenticationDataHolder) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
        }
        catch (AuthorisationIsExpiredException e) {
            return new ResponseEntity((Object)new CmsPaymentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<Void> updatePaymentStatus(String paymentId, String status, String instanceId) {
        return this.cmsPsuPisService.updatePaymentStatus(paymentId, TransactionStatus.valueOf((String)status), instanceId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    public ResponseEntity<List<CmsPisPsuDataAuthorisation>> psuAuthorisationStatuses(String paymentId, String instanceId) {
        return this.cmsPsuPisService.getPsuDataAuthorisations(paymentId, instanceId).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @NotNull
    private ResponseEntity<CmsPayment> getPaymentById(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String paymentId, String instanceId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        return this.cmsPsuPisService.getPayment(psuIdData, paymentId, instanceId).map(payment -> new ResponseEntity(payment, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @ConstructorProperties(value={"cmsPsuPisService"})
    public CmsPsuPisController(CmsPsuPisService cmsPsuPisService) {
        this.cmsPsuPisService = cmsPsuPisService;
    }
}

