/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisApi;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisService;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisPsuDataAuthorisation;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsPsuAisController
implements CmsPsuAisApi {
    private final CmsPsuAisService cmsPsuAisService;

    public ResponseEntity<Object> updatePsuDataInConsent(String consentId, String authorisationId, String instanceId, PsuIdData psuIdData) {
        try {
            return this.cmsPsuAisService.updatePsuDataInConsent(psuIdData, authorisationId, instanceId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
        }
        catch (AuthorisationIsExpiredException e) {
            return new ResponseEntity((Object)new CmsAisConsentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<Object> updateAuthorisationStatus(String consentId, String status, String authorisationId, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, AuthenticationDataHolder authenticationDataHolder) {
        ScaStatus scaStatus = ScaStatus.fromValue((String)status);
        if (scaStatus == null) {
            return ResponseEntity.badRequest().build();
        }
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        try {
            return this.cmsPsuAisService.updateAuthorisationStatus(psuIdData, consentId, authorisationId, scaStatus, instanceId, authenticationDataHolder) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
        }
        catch (AuthorisationIsExpiredException e) {
            return new ResponseEntity((Object)new CmsAisConsentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<Boolean> confirmConsent(String consentId, String instanceId) {
        try {
            return new ResponseEntity((Object)this.cmsPsuAisService.confirmConsent(consentId, instanceId), HttpStatus.OK);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<Boolean> rejectConsent(String consentId, String instanceId) {
        try {
            return new ResponseEntity((Object)this.cmsPsuAisService.rejectConsent(consentId, instanceId), HttpStatus.OK);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<List<CmsAisAccountConsent>> getConsentsForPsu(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.getConsentsForPsu(psuIdData, instanceId), HttpStatus.OK);
    }

    public ResponseEntity<Boolean> revokeConsent(String consentId, String instanceId) {
        try {
            return new ResponseEntity((Object)this.cmsPsuAisService.revokeConsent(consentId, instanceId), HttpStatus.OK);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<Boolean> authorisePartiallyConsent(String consentId, String instanceId) {
        try {
            return new ResponseEntity((Object)this.cmsPsuAisService.authorisePartiallyConsent(consentId, instanceId), HttpStatus.OK);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<CmsAisConsentResponse> getConsentIdByRedirectId(String redirectId, String instanceId) {
        try {
            Optional response = this.cmsPsuAisService.checkRedirectAndGetConsent(redirectId, instanceId);
            if (!response.isPresent()) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            CmsAisConsentResponse cmsAisConsentResponse = (CmsAisConsentResponse)response.get();
            return new ResponseEntity((Object)cmsAisConsentResponse, HttpStatus.OK);
        }
        catch (RedirectUrlIsExpiredException e) {
            return new ResponseEntity((Object)new CmsAisConsentResponse(e.getNokRedirectUri()), HttpStatus.REQUEST_TIMEOUT);
        }
    }

    public ResponseEntity<CmsAisAccountConsent> getConsentByConsentId(String consentId, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuAisService.getConsent(psuIdData, consentId, instanceId).map(aisAccountConsent -> new ResponseEntity(aisAccountConsent, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    public ResponseEntity<CmsPsuAuthorisation> getAuthorisationByAuthorisationId(String authorisationId, String instanceId) {
        return this.cmsPsuAisService.getAuthorisationByAuthorisationId(authorisationId, instanceId).map(payment -> new ResponseEntity(payment, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    public ResponseEntity<Void> putAccountAccessInConsent(String consentId, CmsAisConsentAccessRequest accountAccessRequest, String instanceId) {
        boolean accessSaved = this.cmsPsuAisService.updateAccountAccessInConsent(consentId, accountAccessRequest, instanceId);
        if (accessSaved) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    public ResponseEntity<List<CmsAisPsuDataAuthorisation>> psuDataAuthorisations(String consentId, String instanceId) {
        return this.cmsPsuAisService.getPsuDataAuthorisations(consentId, instanceId).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    private PsuIdData getPsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        return new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
    }

    @ConstructorProperties(value={"cmsPsuAisService"})
    public CmsPsuAisController(CmsPsuAisService cmsPsuAisService) {
        this.cmsPsuAisService = cmsPsuAisService;
    }
}

