/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"psu-api/v1/aspsp-consent-data/consents/{consent-id}"})
@Api(value="psu-api/v1/aspsp-consent-data", tags={"Aspsp Consent Data"})
public class AspspConsentDataPsuApiController {
    private final AspspDataService aspspDataService;

    @GetMapping
    @ApiOperation(value="Get aspsp consent data identified by given consent id / payment id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CmsAspspConsentDataBase64> getAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent / payment identification assigned to the created payment.", example="CxymMkwtykFtTeQuH1jrcoOyzcqCcwNCt5193Gfn33mqqcAy_xw2KPwMd5y6Xxe1EwE0BTNRHeyM0FI90wh0hA==_=_bS6p6XvTWI", required=true) @PathVariable(value="consent-id") String encryptedConsentId) {
        return this.aspspDataService.readAspspConsentData(encryptedConsentId).map(AspspConsentData::getAspspConsentData).map(Base64.getEncoder()::encodeToString).map(aspspConsentDataBase64 -> new CmsAspspConsentDataBase64(encryptedConsentId, aspspConsentDataBase64)).map(cmsAspspConsentDataBase64 -> new ResponseEntity(cmsAspspConsentDataBase64, HttpStatus.OK)).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.notFound()).build());
    }

    @PutMapping
    @ApiOperation(value="Update aspsp consent data identified by given consent id / payment id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity updateAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent / payment identification assigned to the created payment.", example="CxymMkwtykFtTeQuH1jrcoOyzcqCcwNCt5193Gfn33mqqcAy_xw2KPwMd5y6Xxe1EwE0BTNRHeyM0FI90wh0hA==_=_bS6p6XvTWI", required=true) @PathVariable(value="consent-id") String encryptedConsentId, @RequestBody CmsAspspConsentDataBase64 request) {
        byte[] data = Optional.ofNullable(request.getAspspConsentDataBase64()).map(Base64.getDecoder()::decode).orElse(null);
        AspspConsentData aspspConsentData = new AspspConsentData(data, encryptedConsentId);
        boolean updated = this.aspspDataService.updateAspspConsentData(aspspConsentData);
        if (!updated) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return ResponseEntity.ok().build();
    }

    @DeleteMapping
    @ApiOperation(value="Delete aspsp consent data identified by given consent id / payment id.")
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity deleteAspspConsentData(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent / payment identification assigned to the created payment.", example="CxymMkwtykFtTeQuH1jrcoOyzcqCcwNCt5193Gfn33mqqcAy_xw2KPwMd5y6Xxe1EwE0BTNRHeyM0FI90wh0hA==_=_bS6p6XvTWI", required=true) @PathVariable(value="consent-id") String encryptedConsentId) {
        boolean deleted = this.aspspDataService.deleteAspspConsentData(encryptedConsentId);
        if (!deleted) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.noContent().build();
    }

    @ConstructorProperties(value={"aspspDataService"})
    public AspspConsentDataPsuApiController(AspspDataService aspspDataService) {
        this.aspspDataService = aspspDataService;
    }
}

