/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisService;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"psu-api/v1/ais/consent"})
@Api(value="psu-api/v1/ais/consent", tags={"PSU AIS Consents"})
public class CmsPsuAisController {
    private static final String DEFAULT_SERVICE_INSTANCE_ID = "UNDEFINED";
    private final CmsPsuAisService cmsPsuAisService;

    @PutMapping(path={"/{consent-id}/authorisation/{authorisation-id}/psu-data"})
    @ApiOperation(value="Updates PSU Data in consent, based on the trusted information about PSU known to ASPSP (i.e. after authorisation).")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePsuDataInConsent(@ApiParam(name="consent-id", value="The consent identifier", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @ApiParam(name="authorisation-id", value="The authorisation identifier of the current authorisation session", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId, @RequestBody PsuIdData psuIdData) {
        return this.cmsPsuAisService.updatePsuDataInConsent(psuIdData, authorisationId, instanceId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="Returns AIS Consent object by its ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AisAccountConsent.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AisAccountConsent> getConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuAisService.getConsent(psuIdData, consentId, instanceId).map(aisAccountConsent -> new ResponseEntity(aisAccountConsent, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/{consent-id}/authorisation/{authorisation-id}/status/{status}"})
    @ApiOperation(value="Updates a Status of AIS Consent Authorisation by its ID and PSU ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> updateAuthorisationStatus(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'received', 'psuIdentified', 'psuAuthenticated', 'scaMethodSelected', 'started', 'finalised' 'failed' 'exempted'.", example="RECEIVED") @PathVariable(value="status") String status, @ApiParam(name="authorisation-id", value="The consent authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorisation-id") String authorisationId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.updateAuthorisationStatus(psuIdData, consentId, authorisationId, ScaStatus.valueOf((String)status), instanceId), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/confirm-consent"})
    @ApiOperation(value="Puts a Status of AIS Consent object by its ID and PSU ID to VALID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> confirmConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.confirmConsent(psuIdData, consentId, instanceId), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/reject-consent"})
    @ApiOperation(value="Puts a Status of AIS Consent object by its ID and PSU ID to REJECTED")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> rejectConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.rejectConsent(psuIdData, consentId, instanceId), HttpStatus.OK);
    }

    @GetMapping(path={"/consents"})
    @ApiOperation(value="Returns a list of AIS Consent objects by PSU ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<AisAccountConsent>> getConsentsForPsu(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.getConsentsForPsu(psuIdData, instanceId), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/revoke-consent"})
    @ApiOperation(value="Revokes AIS Consent object by its ID. Consent gets status Revoked by PSU.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> revokeConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.revokeConsent(psuIdData, consentId, instanceId), HttpStatus.OK);
    }

    @GetMapping(path={"/redirect/{redirect-id}"})
    @ApiOperation(value="Gets consent response by redirect id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CmsAisConsentResponse.class), @ApiResponse(code=408, message="Request Timeout")})
    public ResponseEntity<CmsAisConsentResponse> getConsentByRedirectId(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(name="redirect-id", value="The redirect identification assigned to the created payment", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="redirect-id") String redirectId, @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        Optional response = this.cmsPsuAisService.checkRedirectAndGetConsent(psuIdData, redirectId, instanceId);
        if (!response.isPresent()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        CmsAisConsentResponse consentResponse = (CmsAisConsentResponse)response.get();
        if (StringUtils.isBlank((CharSequence)consentResponse.getAuthorisationId())) {
            return new ResponseEntity((Object)consentResponse, HttpStatus.REQUEST_TIMEOUT);
        }
        return new ResponseEntity((Object)consentResponse, HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/save-access"})
    @ApiOperation(value="Stores list of accounts with their identifiers in AIS Consent object by its ID. Consent should not be revoked, cancelled or expired.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", reference="Access saved"), @ApiResponse(code=404, message="Not Found", reference="Consent not found or not active")})
    public ResponseEntity<Void> putAccountAccessInConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @RequestBody CmsAisConsentAccessRequest accountAccessRequest) {
        boolean accessSaved = this.cmsPsuAisService.saveAccountAccessInConsent(consentId, accountAccessRequest);
        if (accessSaved) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    private PsuIdData getPsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        return new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
    }

    @ConstructorProperties(value={"cmsPsuAisService"})
    public CmsPsuAisController(CmsPsuAisService cmsPsuAisService) {
        this.cmsPsuAisService = cmsPsuAisService;
    }
}

