/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.CreatePisConsentResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"psu-api/v1/pis/consent"})
@Api(value="psu-api/v1/pis/consent", tags={"PSU PIS, Consents"}, description="Controller for cms-psu-api providing access for PIS consents")
public class CmsPsuPisController {
    private final CmsPsuPisService cmsPsuPisService;

    @PutMapping(path={"/redirects/{redirect-id}/psu-data"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CreatePisConsentResponse.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<CreatePisConsentResponse> updatePsuInPayment(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(name="redirect-id", value="The redirect identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="redirect-id") String redirectId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuPisService.updatePsuInPayment(psuIdData, redirectId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    @GetMapping(path={"/{payment-id}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CmsPayment.class), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<CmsPayment> getPaymentByPaymentId(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="payment-id") String paymentId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuPisService.getPayment(psuIdData, paymentId).map(payment -> new ResponseEntity(payment, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    @GetMapping(path={"/redirects/{redirect-id}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CmsPaymentResponse.class), @ApiResponse(code=408, message="Request Timeout")})
    public ResponseEntity<CmsPaymentResponse> getPaymentByRedirectId(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(name="redirect-id", value="The redirect identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="redirect-id") String redirectId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuPisService.checkRedirectAndGetPayment(psuIdData, redirectId).map(payment -> new ResponseEntity(payment, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.REQUEST_TIMEOUT));
    }

    @PutMapping(path={"/{payment-id}/{authorisation-id}/status/{status}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateAuthorisationStatus(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="payment-id") String paymentId, @ApiParam(name="authorisation-id", value="The payment authorisation identification assigned to the created payment authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorisation-id") String authorisationId, @ApiParam(value="The following code values are permitted 'received', 'psuIdentified', 'psuAuthenticated', 'scaMethodSelected', 'started', 'finalised', 'failed', 'exempted'. These values might be extended by ASPSP by more values.", allowableValues="RECEIVED, PSUIDENTIFIED, PSUAUTHENTICATED, SCAMETHODSELECTED,  STARTED,  FINALISED, FAILED, EXEMPTED") @PathVariable(value="status") String status) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuPisService.updateAuthorisationStatus(psuIdData, paymentId, authorisationId, ScaStatus.valueOf((String)status)) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    @PutMapping(path={"/{payment-id}/status/{status}"})
    @ApiOperation(value="")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not found")})
    public ResponseEntity<Void> updatePaymentStatus(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="payment-id") String paymentId, @ApiParam(value="The following code values are permitted 'ACCP', 'ACSC', 'ACSP', 'ACTC', 'PDNG', 'RCVD', 'RJCT', 'CANC'. These values might be extended by ASPSP by more values.", allowableValues="ACCP,  ACSC, ACSP, ACTC, ACWC, ACWP, RCVD, PDNG, RJCT, CANC") @PathVariable(value="status") String status) {
        return this.cmsPsuPisService.updatePaymentStatus(paymentId, TransactionStatus.valueOf((String)status)) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    @ConstructorProperties(value={"cmsPsuPisService"})
    public CmsPsuPisController(CmsPsuPisService cmsPsuPisService) {
        this.cmsPsuPisService = cmsPsuPisService;
    }
}

