/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.psu.controller;

import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisService;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"psu-api/v1/ais/consent"})
@Api(value="psu-api/v1/ais/consent", tags={"PSU AIS, Consents"}, description="Provides access to consent management system for PSU AIS")
public class CmsPsuAisConsentController {
    private final CmsPsuAisService cmsPsuAisService;

    @PutMapping(path={"/redirects/{redirect-id}/psu-data"})
    @ApiOperation(value="Updates PSU Data in consent, based on the trusted information about PSU known to ASPSP (i.e. after authorisation).")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class)})
    public ResponseEntity<Boolean> updatePsuDataInConsent(@ApiParam(name="redirect-id", value="The redirect identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="redirect-id") String redirectId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.updatePsuDataInConsent(psuIdData, redirectId), HttpStatus.OK);
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="Returns AIS Consent object by its ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AisAccountConsent.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AisAccountConsent> getConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuAisService.getConsent(psuIdData, consentId).map(aisAccountConsent -> new ResponseEntity(aisAccountConsent, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/{consent-id}/authorizations/{authorization-id}/status/{status}"})
    @ApiOperation(value="Updates a Status of AIS Consent Authorisation by its ID and PSU ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> updateAuthorisationStatus(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'received', 'psuIdentified', 'psuAuthenticated', 'scaMethodSelected', 'started', 'finalised' 'failed' 'exempted'.", example="RECEIVED") @PathVariable(value="status") String status, @ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="authorization-id") String authorizationId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.updateAuthorisationStatus(psuIdData, consentId, authorizationId, ScaStatus.valueOf((String)status)), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/confirm-consent"})
    @ApiOperation(value="Puts a Status of AIS Consent object by its ID and PSU ID to VALID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> confirmConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.confirmConsent(psuIdData, consentId), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/reject-consent"})
    @ApiOperation(value="Puts a Status of AIS Consent object by its ID and PSU ID to REJECTED")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> rejectConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.rejectConsent(psuIdData, consentId), HttpStatus.OK);
    }

    @GetMapping(path={"/consents"})
    @ApiOperation(value="Returns a list of AIS Consent objects by PSU ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<AisAccountConsent>> getConsentsForPsu(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.getConsentsForPsu(psuIdData), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/revoke-consent"})
    @ApiOperation(value="Revokes AIS Consent object by its ID. Consent gets status Revoked by PSU.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> revokeConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="consent-id") String consentId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsPsuAisService.revokeConsent(psuIdData, consentId), HttpStatus.OK);
    }

    @GetMapping(path={"/redirects/{redirect-id}"})
    @ApiOperation(value="Gets consent response by redirect id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CmsAisConsentResponse.class), @ApiResponse(code=408, message="Request Timeout")})
    public ResponseEntity<CmsAisConsentResponse> getConsentByRedirectId(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceeding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(name="redirect-id", value="The redirect identification assigned to the created payment", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7") @PathVariable(value="redirect-id") String redirectId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsPsuAisService.checkRedirectAndGetConsent(psuIdData, redirectId).map(consent -> new ResponseEntity(consent, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.REQUEST_TIMEOUT));
    }

    private PsuIdData getPsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        return new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
    }

    @ConstructorProperties(value={"cmsPsuAisService"})
    public CmsPsuAisConsentController(CmsPsuAisService cmsPsuAisService) {
        this.cmsPsuAisService = cmsPsuAisService;
    }
}

