/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.consent.service.authorisation.AisAuthService;
import de.adorsys.psd2.consent.service.authorisation.AuthService;
import de.adorsys.psd2.consent.service.authorisation.PisAuthService;
import de.adorsys.psd2.consent.service.authorisation.PisCancellationAuthService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceResolver {
    private final AisAuthService aisAuthService;
    private final PisAuthService pisAuthService;
    private final PisCancellationAuthService pisCancellationAuthService;

    @NotNull
    public AuthService getAuthService(AuthorisationType authorisationType) {
        switch (authorisationType) {
            case CONSENT: {
                return this.aisAuthService;
            }
            case PIS_CREATION: {
                return this.pisAuthService;
            }
            case PIS_CANCELLATION: {
                return this.pisCancellationAuthService;
            }
        }
        throw new IllegalArgumentException("Unknown authorisation type: " + authorisationType);
    }

    @ConstructorProperties(value={"aisAuthService", "pisAuthService", "pisCancellationAuthService"})
    public AuthServiceResolver(AisAuthService aisAuthService, PisAuthService pisAuthService, PisCancellationAuthService pisCancellationAuthService) {
        this.aisAuthService = aisAuthService;
        this.pisAuthService = pisAuthService;
        this.pisCancellationAuthService = pisCancellationAuthService;
    }
}

