package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuConfirmationOfFundsAuthorisation;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-03-10T13:45:07+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.10 (Azul Systems, Inc.)"
)
@Component
public class CmsPsuAuthorisationMapperImpl implements CmsPsuAuthorisationMapper {

    @Autowired
    private PsuDataMapper psuDataMapper;

    @Override
    public CmsPsuAuthorisation mapToCmsPsuAuthorisation(AuthorisationEntity authorisationEntity) {
        if ( authorisationEntity == null ) {
            return null;
        }

        CmsPsuAuthorisation cmsPsuAuthorisation = new CmsPsuAuthorisation();

        cmsPsuAuthorisation.setPsuId( authorisationEntityPsuDataPsuId( authorisationEntity ) );
        cmsPsuAuthorisation.setAuthorisationId( authorisationEntity.getExternalId() );
        cmsPsuAuthorisation.setType( authorisationEntity.getType() );
        cmsPsuAuthorisation.setScaStatus( authorisationEntity.getScaStatus() );
        cmsPsuAuthorisation.setRedirectUrlExpirationTimestamp( authorisationEntity.getRedirectUrlExpirationTimestamp() );
        cmsPsuAuthorisation.setAuthorisationExpirationTimestamp( authorisationEntity.getAuthorisationExpirationTimestamp() );
        cmsPsuAuthorisation.setScaApproach( authorisationEntity.getScaApproach() );
        cmsPsuAuthorisation.setTppOkRedirectUri( authorisationEntity.getTppOkRedirectUri() );
        cmsPsuAuthorisation.setTppNokRedirectUri( authorisationEntity.getTppNokRedirectUri() );

        return cmsPsuAuthorisation;
    }

    @Override
    public CmsPsuConfirmationOfFundsAuthorisation mapToCmsPsuConfirmationOfFundsAuthorisation(AuthorisationEntity authorisationEntity) {
        if ( authorisationEntity == null ) {
            return null;
        }

        CmsPsuConfirmationOfFundsAuthorisation cmsPsuConfirmationOfFundsAuthorisation = new CmsPsuConfirmationOfFundsAuthorisation();

        cmsPsuConfirmationOfFundsAuthorisation.setPsuIdData( psuDataMapper.mapToPsuIdData( authorisationEntity.getPsuData() ) );
        cmsPsuConfirmationOfFundsAuthorisation.setPiisConsentId( authorisationEntity.getParentExternalId() );
        cmsPsuConfirmationOfFundsAuthorisation.setAuthorisationId( authorisationEntity.getExternalId() );
        cmsPsuConfirmationOfFundsAuthorisation.setType( authorisationEntity.getType() );
        cmsPsuConfirmationOfFundsAuthorisation.setScaStatus( authorisationEntity.getScaStatus() );
        cmsPsuConfirmationOfFundsAuthorisation.setScaApproach( authorisationEntity.getScaApproach() );
        cmsPsuConfirmationOfFundsAuthorisation.setRedirectUrlExpirationTimestamp( authorisationEntity.getRedirectUrlExpirationTimestamp() );
        cmsPsuConfirmationOfFundsAuthorisation.setAuthorisationExpirationTimestamp( authorisationEntity.getAuthorisationExpirationTimestamp() );
        cmsPsuConfirmationOfFundsAuthorisation.setTppOkRedirectUri( authorisationEntity.getTppOkRedirectUri() );
        cmsPsuConfirmationOfFundsAuthorisation.setTppNokRedirectUri( authorisationEntity.getTppNokRedirectUri() );

        return cmsPsuConfirmationOfFundsAuthorisation;
    }

    private String authorisationEntityPsuDataPsuId(AuthorisationEntity authorisationEntity) {
        if ( authorisationEntity == null ) {
            return null;
        }
        PsuData psuData = authorisationEntity.getPsuData();
        if ( psuData == null ) {
            return null;
        }
        String psuId = psuData.getPsuId();
        if ( psuId == null ) {
            return null;
        }
        return psuId;
    }
}
