package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-23T10:21:48+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.9 (Azul Systems, Inc.)"
)
@Component
public class CmsAisConsentMapperImpl extends CmsAisConsentMapper {

    @Override
    public AisConsent mapToAisConsent(CmsConsent cmsConsent) {
        if ( cmsConsent == null ) {
            return null;
        }

        AisConsent aisConsent = new AisConsent();

        aisConsent.setConsentTppInformation( cmsConsent.getTppInformation() );
        aisConsent.setId( cmsConsent.getId() );
        aisConsent.setInternalRequestId( cmsConsent.getInternalRequestId() );
        aisConsent.setConsentStatus( cmsConsent.getConsentStatus() );
        aisConsent.setFrequencyPerDay( cmsConsent.getFrequencyPerDay() );
        aisConsent.setRecurringIndicator( cmsConsent.isRecurringIndicator() );
        aisConsent.setMultilevelScaRequired( cmsConsent.isMultilevelScaRequired() );
        aisConsent.setValidUntil( cmsConsent.getValidUntil() );
        aisConsent.setExpireDate( cmsConsent.getExpireDate() );
        aisConsent.setLastActionDate( cmsConsent.getLastActionDate() );
        aisConsent.setCreationTimestamp( cmsConsent.getCreationTimestamp() );
        aisConsent.setStatusChangeTimestamp( cmsConsent.getStatusChangeTimestamp() );
        aisConsent.setAuthorisationTemplate( cmsConsent.getAuthorisationTemplate() );
        List<PsuIdData> list = cmsConsent.getPsuIdDataList();
        if ( list != null ) {
            aisConsent.setPsuIdDataList( new ArrayList<PsuIdData>( list ) );
        }
        Map<String, Integer> map = cmsConsent.getUsages();
        if ( map != null ) {
            aisConsent.setUsages( new HashMap<String, Integer>( map ) );
        }
        aisConsent.setTppAccountAccesses( cmsConsent.getTppAccountAccesses() );
        aisConsent.setAspspAccountAccesses( cmsConsent.getAspspAccountAccesses() );
        aisConsent.setInstanceId( cmsConsent.getInstanceId() );
        aisConsent.setConsentType( cmsConsent.getConsentType() );
        aisConsent.setSigningBasketBlocked( cmsConsent.isSigningBasketBlocked() );
        aisConsent.setSigningBasketAuthorised( cmsConsent.isSigningBasketAuthorised() );

        aisConsent.setConsentData( consentDataMapper.mapToAisConsentData(cmsConsent.getConsentData()) );
        aisConsent.setAuthorisations( mapToAccountConsentAuthorisation(cmsConsent.getAuthorisations()) );

        return aisConsent;
    }
}
