/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider.jwe;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.AESEncrypter;
import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.AbstractCryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JweCryptoProviderImpl
extends AbstractCryptoProvider
implements CryptoProvider {
    private static final Logger log = LoggerFactory.getLogger(JweCryptoProviderImpl.class);
    private static final EncryptionMethod METHOD = EncryptionMethod.A256GCM;
    private static final JWEAlgorithm ALGORITHM = JWEAlgorithm.A256GCMKW;

    public JweCryptoProviderImpl(String cryptoProviderId, int keyLength, int hashIterations, String skfAlgorithm) {
        super(keyLength, hashIterations, skfAlgorithm, cryptoProviderId);
    }

    @Override
    public Optional<EncryptedData> encryptData(byte[] data, String password) {
        try {
            Payload payload = new Payload(data);
            SecretKey secretKey = this.getSecretKey(password);
            JWEHeader header = new JWEHeader(ALGORITHM, METHOD);
            JWEObject jweObject = new JWEObject(header, payload);
            AESEncrypter encrypter = new AESEncrypter(secretKey.getEncoded());
            jweObject.encrypt((JWEEncrypter)encrypter);
            String encryptedData = jweObject.serialize();
            return Optional.of(new EncryptedData(encryptedData.getBytes()));
        }
        catch (JOSEException | GeneralSecurityException e) {
            log.info("Error encryption data: ", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<DecryptedData> decryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            JWEObject jweObject = JWEObject.parse((String)new String(data));
            AESDecrypter decrypter = new AESDecrypter(secretKey.getEncoded());
            jweObject.decrypt((JWEDecrypter)decrypter);
            return Optional.of(new DecryptedData(jweObject.getPayload().toBytes()));
        }
        catch (Exception e) {
            log.info("Error encryption data. Data can't be parsed : ", (Throwable)e);
            return Optional.empty();
        }
    }
}

