/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.pis.CmsAspspPisExportService;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.specification.PisCommonPaymentDataSpecification;
import de.adorsys.psd2.consent.service.mapper.CmsPsuPisMapper;
import de.adorsys.psd2.consent.service.psu.util.PageRequestBuilder;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspPisExportServiceInternal
implements CmsAspspPisExportService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspPisExportServiceInternal.class);
    private final PisCommonPaymentDataSpecification pisCommonPaymentDataSpecification;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final CmsPsuPisMapper cmsPsuPisMapper;
    private final PageRequestBuilder pageRequestBuilder;

    public PageData<Collection<CmsPayment>> exportPaymentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}], TPP ID: [{}]. Export payments by TPP failed, TPP ID or instanceId is empty or null.", (Object)instanceId, (Object)tppAuthorisationNumber);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        return this.mapToPageData((Page<PisCommonPaymentData>)this.pisCommonPaymentDataRepository.findAll(this.pisCommonPaymentDataSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    public PageData<Collection<CmsPayment>> exportPaymentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (psuIdData == null || psuIdData.isEmpty() || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}]. Export payments by psu failed, psuIdData or instanceId is empty or null.", (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        return this.mapToPageData((Page<PisCommonPaymentData>)this.pisCommonPaymentDataRepository.findAll(this.pisCommonPaymentDataSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    public PageData<Collection<CmsPayment>> exportPaymentsByAccountId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (StringUtils.isBlank((CharSequence)aspspAccountId) || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}], aspspAccountId: [{}]. Export payments by accountId failed, aspspAccountId or instanceId is empty or null.", (Object)instanceId, (Object)aspspAccountId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        return this.mapToPageData((Page<PisCommonPaymentData>)this.pisCommonPaymentDataRepository.findAll(this.pisCommonPaymentDataSpecification.byAspspAccountIdAndCreationPeriodAndInstanceId(aspspAccountId, createDateFrom, createDateTo, instanceId), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    private PageData<Collection<CmsPayment>> mapToPageData(Page<PisCommonPaymentData> entities) {
        return new PageData((Object)entities.stream().map(this.cmsPsuPisMapper::mapPaymentDataToCmsPayment).collect(Collectors.toList()), (long)entities.getPageable().getPageNumber(), (long)entities.getPageable().getPageSize(), entities.getTotalElements());
    }

    @ConstructorProperties(value={"pisCommonPaymentDataSpecification", "pisCommonPaymentDataRepository", "cmsPsuPisMapper", "pageRequestBuilder"})
    public CmsAspspPisExportServiceInternal(PisCommonPaymentDataSpecification pisCommonPaymentDataSpecification, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, CmsPsuPisMapper cmsPsuPisMapper, PageRequestBuilder pageRequestBuilder) {
        this.pisCommonPaymentDataSpecification = pisCommonPaymentDataSpecification;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.cmsPsuPisMapper = cmsPsuPisMapper;
        this.pageRequestBuilder = pageRequestBuilder;
    }
}

