/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.psd2.consent.api.pis.CmsCommonPayment;
import de.adorsys.psd2.consent.api.pis.CmsCommonPaymentMapper;
import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.service.PaymentMapperResolver;
import de.adorsys.psd2.consent.service.mapper.CmsCorePaymentMapper;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.beans.ConstructorProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CorePaymentsConvertService {
    private static final Logger log = LoggerFactory.getLogger(CorePaymentsConvertService.class);
    private final CmsCorePaymentMapper cmsCorePaymentMapper;
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final PaymentMapperResolver paymentMapperResolver;

    public byte[] buildPaymentData(List<PisPayment> pisPayments, PaymentType paymentType) {
        switch (paymentType) {
            case SINGLE: {
                return this.writeValueAsBytes(this.cmsCorePaymentMapper.mapToPaymentInitiationJson(pisPayments));
            }
            case BULK: {
                return this.writeValueAsBytes(this.cmsCorePaymentMapper.mapToBulkPaymentInitiationJson(pisPayments));
            }
            case PERIODIC: {
                return this.writeValueAsBytes(this.cmsCorePaymentMapper.mapToPeriodicPaymentInitiationJson(pisPayments));
            }
        }
        return new byte[0];
    }

    public CmsPayment expandCommonPaymentWithCorePayment(CmsCommonPayment cmsCommonPayment) {
        CmsCommonPaymentMapper cmsCommonPaymentMapper = this.paymentMapperResolver.getCmsCommonPaymentMapper(cmsCommonPayment.getPaymentProduct());
        switch (cmsCommonPayment.getPaymentType()) {
            case SINGLE: {
                return cmsCommonPaymentMapper.mapToCmsSinglePayment(cmsCommonPayment);
            }
            case BULK: {
                return cmsCommonPaymentMapper.mapToCmsBulkPayment(cmsCommonPayment);
            }
            case PERIODIC: {
                return cmsCommonPaymentMapper.mapToCmsPeriodicPayment(cmsCommonPayment);
            }
        }
        return cmsCommonPayment;
    }

    private byte[] writeValueAsBytes(Object object) {
        if (object == null) {
            return new byte[0];
        }
        try {
            return this.xs2aObjectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            log.warn("Can't convert object to byte[] : {}", (Object)e.getMessage());
            return new byte[0];
        }
    }

    @ConstructorProperties(value={"cmsCorePaymentMapper", "xs2aObjectMapper", "paymentMapperResolver"})
    public CorePaymentsConvertService(CmsCorePaymentMapper cmsCorePaymentMapper, Xs2aObjectMapper xs2aObjectMapper, PaymentMapperResolver paymentMapperResolver) {
        this.cmsCorePaymentMapper = cmsCorePaymentMapper;
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.paymentMapperResolver = paymentMapperResolver;
    }
}

