/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.specification.CommonSpecification;
import de.adorsys.psd2.consent.repository.specification.ConsentFilterableSpecification;
import de.adorsys.psd2.consent.repository.specification.ConsentSpecification;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.io.Serializable;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Join;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentEntitySpecification
extends ConsentFilterableSpecification {
    private final CommonSpecification<ConsentEntity> commonSpecification;
    private final ConsentSpecification consentSpecification;

    public PiisConsentEntitySpecification(CommonSpecification<ConsentEntity> commonSpecification, ConsentSpecification consentSpecification) {
        super(commonSpecification, consentSpecification);
        this.commonSpecification = commonSpecification;
        this.consentSpecification = consentSpecification;
    }

    @Override
    public List<ConsentType> getTypes() {
        return Collections.singletonList(ConsentType.PIIS_ASPSP);
    }

    public Specification<ConsentEntity> byPsuDataAndInstanceId(PsuIdData psuIdData, String instanceId) {
        return this.consentSpecification.byPsuDataInListAndInstanceId(psuIdData, instanceId).and(this.byConsentType());
    }

    public Specification<ConsentEntity> byPsuIdDataAndAuthorisationNumberAndAccountReferenceAndInstanceId(@NotNull PsuIdData psuIdData, @NotNull String tppAuthorisationNumber, @NotNull AccountReference accountReference, @NotNull String instanceId) {
        return Optional.of(Specification.where(this.commonSpecification.byPsuIdDataInList(psuIdData))).map(s -> s.and(this.consentSpecification.byTpp(tppAuthorisationNumber))).map(s -> s.and(this.byAccountReference(accountReference))).map(s -> s.and(this.byConsentType())).map(s -> s.and(this.commonSpecification.byInstanceId(instanceId))).orElse(null);
    }

    public Specification<ConsentEntity> byCurrencyAndAccountReferenceSelector(@Nullable Currency currency, @NotNull AccountReferenceSelector selector) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join aspspAccountAccessesJoin = root.join("aspspAccountAccesses");
            return Optional.of(Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessesJoin, "accountIdentifier", selector.getAccountValue()))).map(s -> s.and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessesJoin, "currency", currency))).map(s -> s.and(this.byConsentType())).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    public Specification<ConsentEntity> byAccountReferenceSelector(@NotNull AccountReferenceSelector selector) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join aspspAccountAccessesJoin = root.join("aspspAccountAccesses");
            return Optional.of(Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessesJoin, "accountIdentifier", selector.getAccountValue()))).map(s -> s.and(this.byConsentType())).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    private Specification<ConsentEntity> byAccountReference(@NotNull AccountReference accountReference) {
        return (Specification & Serializable)(root, query, cb) -> {
            AccountReferenceSelector selector = accountReference.getUsedAccountReferenceSelector();
            Join aspspAccountAccessJoin = root.join("aspspAccountAccesses");
            Specification specifications = Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessJoin, "accountIdentifier", selector.getAccountValue()));
            if (accountReference.getCurrency() != null) {
                specifications.and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessJoin, "currency", accountReference.getCurrency()));
            }
            return specifications.toPredicate(root, query, cb);
        };
    }
}

