/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.payment;

import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.pis.InternalPaymentStatus;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity(name="pis_common_payment")
public class PisCommonPaymentData
extends InstanceDependableEntity
implements Authorisable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_common_payment_generator")
    @SequenceGenerator(name="pis_common_payment_generator", sequenceName="pis_common_payment_id_seq", allocationSize=1)
    private Long id;
    @Column(name="payment_id", nullable=false)
    private String paymentId;
    @Column(name="payment_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PaymentType paymentType;
    @Column(name="payment_product", nullable=false)
    private String paymentProduct;
    @Column(name="transaction_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private TransactionStatus transactionStatus;
    @Column(name="internal_payment_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private InternalPaymentStatus internalPaymentStatus;
    @Lob
    @Column(name="payment")
    private byte[] payment;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="pis_common_payment_psu_data", joinColumns={@JoinColumn(name="pis_common_payment_id")}, inverseJoinColumns={@JoinColumn(name="psu_data_id")})
    private List<PsuData> psuDataList = new ArrayList<PsuData>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id", nullable=false)
    private TppInfoEntity tppInfo;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="authorisation_template_id", nullable=false)
    private AuthorisationTemplateEntity authorisationTemplate;
    @Column(name="tpp_ntfc_uri")
    private String tppNotificationUri;
    @ElementCollection
    @CollectionTable(name="payment_tpp_ntfc", joinColumns={@JoinColumn(name="id")})
    @Column(name="notification_mode", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private List<NotificationSupportedMode> tppNotificationContentPreferred;
    @OneToMany(mappedBy="paymentData", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PisPaymentData> payments = new ArrayList<PisPaymentData>();
    @Column(name="creation_timestamp", nullable=false)
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="multilevel_sca_required", nullable=false)
    private boolean multilevelScaRequired;
    @Column(name="aspsp_account_id", length=100)
    private String aspspAccountId;
    @Column(name="status_change_timestamp")
    private OffsetDateTime statusChangeTimestamp;
    @Column(name="int_req_id")
    private String internalRequestId;
    @Column(name="canc_int_req_id")
    private String cancellationInternalRequestId;
    @Column(name="content_type")
    private String contentType;
    @Column(name="tpp_brand_log_info")
    private String tppBrandLoggingInformation;
    @Transient
    private TransactionStatus previousTransactionStatus;

    @PostLoad
    public void pisCommonPaymentDataPostLoad() {
        this.previousTransactionStatus = this.transactionStatus;
    }

    @PreUpdate
    public void pisCommonPaymentDataPreUpdate() {
        if (this.previousTransactionStatus != this.transactionStatus) {
            this.statusChangeTimestamp = OffsetDateTime.now();
        }
    }

    @PrePersist
    public void pisCommonPaymentDataPrePersist() {
        if (Objects.isNull(this.statusChangeTimestamp)) {
            this.statusChangeTimestamp = this.creationTimestamp;
        }
    }

    public boolean isConfirmationExpired(long expirationPeriodMs) {
        if (this.isNotConfirmed()) {
            return this.creationTimestamp.plus(expirationPeriodMs, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
        }
        return false;
    }

    private boolean isNotConfirmed() {
        return EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC).contains(this.transactionStatus);
    }

    public boolean isFinalised() {
        return this.transactionStatus.isFinalisedStatus();
    }

    @Override
    public String getExternalId() {
        return this.paymentId;
    }

    @Override
    public String getInternalRequestId(AuthorisationType authorisationType) {
        if (authorisationType == AuthorisationType.PIS_CREATION) {
            return this.internalRequestId;
        }
        if (authorisationType == AuthorisationType.PIS_CANCELLATION) {
            return this.cancellationInternalRequestId;
        }
        throw new IllegalArgumentException("Invalid authorisation type: " + authorisationType);
    }

    public Long getId() {
        return this.id;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public InternalPaymentStatus getInternalPaymentStatus() {
        return this.internalPaymentStatus;
    }

    public byte[] getPayment() {
        return this.payment;
    }

    @Override
    public List<PsuData> getPsuDataList() {
        return this.psuDataList;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    @Override
    public AuthorisationTemplateEntity getAuthorisationTemplate() {
        return this.authorisationTemplate;
    }

    public String getTppNotificationUri() {
        return this.tppNotificationUri;
    }

    public List<NotificationSupportedMode> getTppNotificationContentPreferred() {
        return this.tppNotificationContentPreferred;
    }

    public List<PisPaymentData> getPayments() {
        return this.payments;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public String getCancellationInternalRequestId() {
        return this.cancellationInternalRequestId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getTppBrandLoggingInformation() {
        return this.tppBrandLoggingInformation;
    }

    public TransactionStatus getPreviousTransactionStatus() {
        return this.previousTransactionStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setInternalPaymentStatus(InternalPaymentStatus internalPaymentStatus) {
        this.internalPaymentStatus = internalPaymentStatus;
    }

    public void setPayment(byte[] payment) {
        this.payment = payment;
    }

    @Override
    public void setPsuDataList(List<PsuData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAuthorisationTemplate(AuthorisationTemplateEntity authorisationTemplate) {
        this.authorisationTemplate = authorisationTemplate;
    }

    public void setTppNotificationUri(String tppNotificationUri) {
        this.tppNotificationUri = tppNotificationUri;
    }

    public void setTppNotificationContentPreferred(List<NotificationSupportedMode> tppNotificationContentPreferred) {
        this.tppNotificationContentPreferred = tppNotificationContentPreferred;
    }

    public void setPayments(List<PisPaymentData> payments) {
        this.payments = payments;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setInternalRequestId(String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public void setCancellationInternalRequestId(String cancellationInternalRequestId) {
        this.cancellationInternalRequestId = cancellationInternalRequestId;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setTppBrandLoggingInformation(String tppBrandLoggingInformation) {
        this.tppBrandLoggingInformation = tppBrandLoggingInformation;
    }

    public void setPreviousTransactionStatus(TransactionStatus previousTransactionStatus) {
        this.previousTransactionStatus = previousTransactionStatus;
    }

    public String toString() {
        return "PisCommonPaymentData(id=" + this.getId() + ", paymentId=" + this.getPaymentId() + ", paymentType=" + this.getPaymentType() + ", paymentProduct=" + this.getPaymentProduct() + ", transactionStatus=" + this.getTransactionStatus() + ", internalPaymentStatus=" + this.getInternalPaymentStatus() + ", payment=" + Arrays.toString(this.getPayment()) + ", psuDataList=" + this.getPsuDataList() + ", tppInfo=" + this.getTppInfo() + ", authorisationTemplate=" + this.getAuthorisationTemplate() + ", tppNotificationUri=" + this.getTppNotificationUri() + ", tppNotificationContentPreferred=" + this.getTppNotificationContentPreferred() + ", payments=" + this.getPayments() + ", creationTimestamp=" + this.getCreationTimestamp() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", aspspAccountId=" + this.getAspspAccountId() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", internalRequestId=" + this.getInternalRequestId() + ", cancellationInternalRequestId=" + this.getCancellationInternalRequestId() + ", contentType=" + this.getContentType() + ", tppBrandLoggingInformation=" + this.getTppBrandLoggingInformation() + ", previousTransactionStatus=" + this.getPreviousTransactionStatus() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisCommonPaymentData)) {
            return false;
        }
        PisCommonPaymentData other = (PisCommonPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        InternalPaymentStatus this$internalPaymentStatus = this.getInternalPaymentStatus();
        InternalPaymentStatus other$internalPaymentStatus = other.getInternalPaymentStatus();
        if (this$internalPaymentStatus == null ? other$internalPaymentStatus != null : !this$internalPaymentStatus.equals(other$internalPaymentStatus)) {
            return false;
        }
        if (!Arrays.equals(this.getPayment(), other.getPayment())) {
            return false;
        }
        List<PsuData> this$psuDataList = this.getPsuDataList();
        List<PsuData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        AuthorisationTemplateEntity this$authorisationTemplate = this.getAuthorisationTemplate();
        AuthorisationTemplateEntity other$authorisationTemplate = other.getAuthorisationTemplate();
        if (this$authorisationTemplate == null ? other$authorisationTemplate != null : !((Object)this$authorisationTemplate).equals(other$authorisationTemplate)) {
            return false;
        }
        String this$tppNotificationUri = this.getTppNotificationUri();
        String other$tppNotificationUri = other.getTppNotificationUri();
        if (this$tppNotificationUri == null ? other$tppNotificationUri != null : !this$tppNotificationUri.equals(other$tppNotificationUri)) {
            return false;
        }
        List<NotificationSupportedMode> this$tppNotificationContentPreferred = this.getTppNotificationContentPreferred();
        List<NotificationSupportedMode> other$tppNotificationContentPreferred = other.getTppNotificationContentPreferred();
        if (this$tppNotificationContentPreferred == null ? other$tppNotificationContentPreferred != null : !((Object)this$tppNotificationContentPreferred).equals(other$tppNotificationContentPreferred)) {
            return false;
        }
        List<PisPaymentData> this$payments = this.getPayments();
        List<PisPaymentData> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        if (this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        if (this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId)) {
            return false;
        }
        String this$cancellationInternalRequestId = this.getCancellationInternalRequestId();
        String other$cancellationInternalRequestId = other.getCancellationInternalRequestId();
        if (this$cancellationInternalRequestId == null ? other$cancellationInternalRequestId != null : !this$cancellationInternalRequestId.equals(other$cancellationInternalRequestId)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$tppBrandLoggingInformation = this.getTppBrandLoggingInformation();
        String other$tppBrandLoggingInformation = other.getTppBrandLoggingInformation();
        if (this$tppBrandLoggingInformation == null ? other$tppBrandLoggingInformation != null : !this$tppBrandLoggingInformation.equals(other$tppBrandLoggingInformation)) {
            return false;
        }
        TransactionStatus this$previousTransactionStatus = this.getPreviousTransactionStatus();
        TransactionStatus other$previousTransactionStatus = other.getPreviousTransactionStatus();
        return !(this$previousTransactionStatus == null ? other$previousTransactionStatus != null : !this$previousTransactionStatus.equals(other$previousTransactionStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PisCommonPaymentData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        InternalPaymentStatus $internalPaymentStatus = this.getInternalPaymentStatus();
        result = result * 59 + ($internalPaymentStatus == null ? 43 : $internalPaymentStatus.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayment());
        List<PsuData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        AuthorisationTemplateEntity $authorisationTemplate = this.getAuthorisationTemplate();
        result = result * 59 + ($authorisationTemplate == null ? 43 : ((Object)$authorisationTemplate).hashCode());
        String $tppNotificationUri = this.getTppNotificationUri();
        result = result * 59 + ($tppNotificationUri == null ? 43 : $tppNotificationUri.hashCode());
        List<NotificationSupportedMode> $tppNotificationContentPreferred = this.getTppNotificationContentPreferred();
        result = result * 59 + ($tppNotificationContentPreferred == null ? 43 : ((Object)$tppNotificationContentPreferred).hashCode());
        List<PisPaymentData> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        String $cancellationInternalRequestId = this.getCancellationInternalRequestId();
        result = result * 59 + ($cancellationInternalRequestId == null ? 43 : $cancellationInternalRequestId.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $tppBrandLoggingInformation = this.getTppBrandLoggingInformation();
        result = result * 59 + ($tppBrandLoggingInformation == null ? 43 : $tppBrandLoggingInformation.hashCode());
        TransactionStatus $previousTransactionStatus = this.getPreviousTransactionStatus();
        result = result * 59 + ($previousTransactionStatus == null ? 43 : $previousTransactionStatus.hashCode());
        return result;
    }
}

