/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.consent;

import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="consent_tpp_information")
@ApiModel(description="Consent tpp information", value="ConsentTppInformationEntity")
public class ConsentTppInformationEntity {
    @Id
    @Column(name="consent_tpp_information_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="consent_tpp_information_generator")
    @SequenceGenerator(name="consent_tpp_information_generator", sequenceName="consent_tpp_info_id_seq", allocationSize=1)
    private Long id;
    @Column(name="tpp_redirect_preferred", nullable=false)
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.", required=true, example="false")
    private boolean tppRedirectPreferred;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id", nullable=false)
    @ApiModelProperty(value="Information about TPP", required=true)
    private TppInfoEntity tppInfo;
    @Column(name="tpp_frequency_per_day")
    private int tppFrequencyPerDay;
    @Column(name="tpp_ntfc_uri")
    private String tppNotificationUri;
    @Column(name="tpp_brand_log_info")
    private String tppBrandLoggingInformation;
    @ElementCollection
    @CollectionTable(name="ais_consent_tpp_ntfc", joinColumns={@JoinColumn(name="id")})
    @Column(name="notification_mode", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private List<NotificationSupportedMode> tppNotificationContentPreferred;

    public Long getId() {
        return this.id;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    public int getTppFrequencyPerDay() {
        return this.tppFrequencyPerDay;
    }

    public String getTppNotificationUri() {
        return this.tppNotificationUri;
    }

    public String getTppBrandLoggingInformation() {
        return this.tppBrandLoggingInformation;
    }

    public List<NotificationSupportedMode> getTppNotificationContentPreferred() {
        return this.tppNotificationContentPreferred;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setTppFrequencyPerDay(int tppFrequencyPerDay) {
        this.tppFrequencyPerDay = tppFrequencyPerDay;
    }

    public void setTppNotificationUri(String tppNotificationUri) {
        this.tppNotificationUri = tppNotificationUri;
    }

    public void setTppBrandLoggingInformation(String tppBrandLoggingInformation) {
        this.tppBrandLoggingInformation = tppBrandLoggingInformation;
    }

    public void setTppNotificationContentPreferred(List<NotificationSupportedMode> tppNotificationContentPreferred) {
        this.tppNotificationContentPreferred = tppNotificationContentPreferred;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsentTppInformationEntity)) {
            return false;
        }
        ConsentTppInformationEntity other = (ConsentTppInformationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        if (this.getTppFrequencyPerDay() != other.getTppFrequencyPerDay()) {
            return false;
        }
        String this$tppNotificationUri = this.getTppNotificationUri();
        String other$tppNotificationUri = other.getTppNotificationUri();
        if (this$tppNotificationUri == null ? other$tppNotificationUri != null : !this$tppNotificationUri.equals(other$tppNotificationUri)) {
            return false;
        }
        String this$tppBrandLoggingInformation = this.getTppBrandLoggingInformation();
        String other$tppBrandLoggingInformation = other.getTppBrandLoggingInformation();
        if (this$tppBrandLoggingInformation == null ? other$tppBrandLoggingInformation != null : !this$tppBrandLoggingInformation.equals(other$tppBrandLoggingInformation)) {
            return false;
        }
        List<NotificationSupportedMode> this$tppNotificationContentPreferred = this.getTppNotificationContentPreferred();
        List<NotificationSupportedMode> other$tppNotificationContentPreferred = other.getTppNotificationContentPreferred();
        return !(this$tppNotificationContentPreferred == null ? other$tppNotificationContentPreferred != null : !((Object)this$tppNotificationContentPreferred).equals(other$tppNotificationContentPreferred));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsentTppInformationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        result = result * 59 + this.getTppFrequencyPerDay();
        String $tppNotificationUri = this.getTppNotificationUri();
        result = result * 59 + ($tppNotificationUri == null ? 43 : $tppNotificationUri.hashCode());
        String $tppBrandLoggingInformation = this.getTppBrandLoggingInformation();
        result = result * 59 + ($tppBrandLoggingInformation == null ? 43 : $tppBrandLoggingInformation.hashCode());
        List<NotificationSupportedMode> $tppNotificationContentPreferred = this.getTppNotificationContentPreferred();
        result = result * 59 + ($tppNotificationContentPreferred == null ? 43 : ((Object)$tppNotificationContentPreferred).hashCode());
        return result;
    }

    public String toString() {
        return "ConsentTppInformationEntity(id=" + this.getId() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", tppInfo=" + this.getTppInfo() + ", tppFrequencyPerDay=" + this.getTppFrequencyPerDay() + ", tppNotificationUri=" + this.getTppNotificationUri() + ", tppBrandLoggingInformation=" + this.getTppBrandLoggingInformation() + ", tppNotificationContentPreferred=" + this.getTppNotificationContentPreferred() + ")";
    }
}

