/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.util.Optional;
import java.util.function.Function;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", imports={Optional.class, TppRedirectUri.class})
public interface AuthorisationTemplateMapper {
    @Mappings(value={@Mapping(target="tppRedirectUri", expression="java(createTppRedirectUri(entity.getRedirectUri(), entity.getNokRedirectUri()))"), @Mapping(target="cancelTppRedirectUri", expression="java(createTppRedirectUri(entity.getCancelRedirectUri(), entity.getCancelNokRedirectUri()))")})
    public AuthorisationTemplate mapToAuthorisationTemplate(AuthorisationTemplateEntity var1);

    @Mappings(value={@Mapping(target="redirectUri", expression="java(getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getUri))"), @Mapping(target="nokRedirectUri", expression="java(getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getNokUri))"), @Mapping(target="cancelRedirectUri", expression="java(getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getUri))"), @Mapping(target="cancelNokRedirectUri", expression="java(getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getNokUri))")})
    public AuthorisationTemplateEntity mapToAuthorisationTemplateEntity(AuthorisationTemplate var1);

    default public TppRedirectUri createTppRedirectUri(String redirectUri, String nokRedirectUri) {
        if (redirectUri != null) {
            return new TppRedirectUri(redirectUri, nokRedirectUri);
        }
        return null;
    }

    default public String getUriOrNull(TppRedirectUri tppRedirectUri, Function<TppRedirectUri, String> function) {
        return Optional.ofNullable(tppRedirectUri).map(function).orElse(null);
    }
}

