/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.specification.AuthorisationSpecification;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CmsConsentAuthorisationServiceInternal {
    private static final Logger log = LoggerFactory.getLogger(CmsConsentAuthorisationServiceInternal.class);
    private final AuthorisationRepository authorisationRepository;
    private final AuthorisationSpecification authorisationSpecification;

    public Optional<AuthorisationEntity> getAuthorisationByAuthorisationId(@NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        Optional authorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (authorisation.isPresent() && !((AuthorisationEntity)authorisation.get()).isAuthorisationNotExpired()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Authorisation is expired", (Object)authorisationId, (Object)instanceId);
            throw new AuthorisationIsExpiredException(((AuthorisationEntity)authorisation.get()).getTppNokRedirectUri());
        }
        return authorisation;
    }

    public Optional<AuthorisationEntity> getAuthorisationByRedirectId(String redirectId, String instanceId) throws RedirectUrlIsExpiredException {
        Optional authorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId));
        if (authorisation.isPresent() && !((AuthorisationEntity)authorisation.get()).isRedirectUrlNotExpired()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get consent failed, because authorisation is expired", (Object)redirectId, (Object)instanceId);
            ((AuthorisationEntity)authorisation.get()).setScaStatus(ScaStatus.FAILED);
            throw new RedirectUrlIsExpiredException(((AuthorisationEntity)authorisation.get()).getTppNokRedirectUri());
        }
        return authorisation;
    }

    public boolean updateScaStatusAndAuthenticationData(@NotNull ScaStatus status, AuthorisationEntity authorisation, AuthenticationDataHolder authenticationDataHolder) {
        if (authorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID [{}], SCA status [{}]. Update authorisation status failed in updateScaStatusAndAuthenticationData method because authorisation has finalised status.", (Object)authorisation.getExternalId(), (Object)authorisation.getScaStatus().getValue());
            return false;
        }
        authorisation.setScaStatus(status);
        if (authenticationDataHolder != null) {
            this.enrichAuthorisationWithAuthenticationData(authorisation, authenticationDataHolder);
        }
        return true;
    }

    public List<AuthorisationEntity> getAuthorisationsByParentExternalId(String externalId) {
        return this.authorisationRepository.findAllByParentExternalIdAndType(externalId, AuthorisationType.CONSENT);
    }

    private void enrichAuthorisationWithAuthenticationData(AuthorisationEntity authorisation, AuthenticationDataHolder authenticationDataHolder) {
        if (authenticationDataHolder.getAuthenticationData() != null) {
            authorisation.setScaAuthenticationData(authenticationDataHolder.getAuthenticationData());
        }
        if (authenticationDataHolder.getAuthenticationMethodId() != null) {
            authorisation.setAuthenticationMethodId(authenticationDataHolder.getAuthenticationMethodId());
        }
    }

    @ConstructorProperties(value={"authorisationRepository", "authorisationSpecification"})
    public CmsConsentAuthorisationServiceInternal(AuthorisationRepository authorisationRepository, AuthorisationSpecification authorisationSpecification) {
        this.authorisationRepository = authorisationRepository;
        this.authorisationSpecification = authorisationSpecification;
    }
}

