/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.aspsp.api.psu.CmsAspspPsuAccountService;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.ConsentSpecification;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsAspspPsuAccountServiceInternal
implements CmsAspspPsuAccountService {
    private final ConsentSpecification consentSpecification;
    private final ConsentJpaRepository consentJpaRepository;

    @Transactional
    public boolean revokeAllConsents(@Nullable String aspspAccountId, @NotNull PsuIdData psuIdData, @Nullable String instanceId) {
        List consents = this.consentJpaRepository.findAll(this.consentSpecification.byPsuIdDataAndAspspAccountIdAndInstanceId(psuIdData, aspspAccountId, instanceId));
        List<ConsentEntity> filteredConsents = consents.stream().filter(cst -> !cst.getConsentStatus().isFinalisedStatus()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredConsents)) {
            return false;
        }
        filteredConsents.forEach(cst -> {
            cst.setLastActionDate(LocalDate.now());
            cst.setConsentStatus(ConsentStatus.REVOKED_BY_PSU);
            this.consentJpaRepository.save(cst);
        });
        return true;
    }

    @ConstructorProperties(value={"consentSpecification", "consentJpaRepository"})
    public CmsAspspPsuAccountServiceInternal(ConsentSpecification consentSpecification, ConsentJpaRepository consentJpaRepository) {
        this.consentSpecification = consentSpecification;
        this.consentJpaRepository = consentJpaRepository;
    }
}

