/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternalEncrypted
implements PisCommonPaymentServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(PisCommonPaymentServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final PisCommonPaymentService pisCommonPaymentService;

    @Transactional
    public CmsResponse<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        CmsResponse paymentResponse = this.pisCommonPaymentService.createCommonPayment(request);
        if (paymentResponse.hasError()) {
            return paymentResponse;
        }
        CreatePisCommonPaymentResponse payment = (CreatePisCommonPaymentResponse)paymentResponse.getPayload();
        Optional<String> encryptIdOptional = this.securityDataService.encryptId(payment.getPaymentId());
        if (encryptIdOptional.isEmpty()) {
            log.info("Payment ID: [{}]. Create common payment failed, couldn't encrypt payment id", (Object)payment.getPaymentId());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return CmsResponse.builder().payload((Object)new CreatePisCommonPaymentResponse(encryptIdOptional.get(), payment.getTppNotificationContentPreferred())).build();
    }

    @Transactional
    public CmsResponse<TransactionStatus> getPisCommonPaymentStatusById(String encryptedPaymentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Payment ID: [{}]. Get common payment status by ID failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisCommonPaymentService.getPisCommonPaymentStatusById(decryptIdOptional.get());
    }

    @Transactional
    public CmsResponse<PisCommonPaymentResponse> getCommonPaymentById(String encryptedPaymentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Payment ID: [{}]. Get common payment by ID failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisCommonPaymentService.getCommonPaymentById(decryptIdOptional.get());
    }

    @Transactional
    public CmsResponse<Boolean> updateCommonPaymentStatusById(String encryptedPaymentId, TransactionStatus status) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Payment ID: [{}]. Get common payment status by ID failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisCommonPaymentService.updateCommonPaymentStatusById(decryptIdOptional.get(), status);
    }

    public CmsResponse<String> getDecryptedId(String encryptedId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Payment ID: [{}]. Couldn't decrypt consent id", (Object)encryptedId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return CmsResponse.builder().payload((Object)decryptIdOptional.get()).build();
    }

    @Transactional
    public CmsResponse<Boolean> updateMultilevelSca(String encryptedPaymentId, boolean multilevelScaRequired) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Payment ID: [{}]. Update payment multilevel SCA failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisCommonPaymentService.updateMultilevelSca(decryptIdOptional.get(), multilevelScaRequired);
    }

    public CmsResponse<List<PsuIdData>> getPsuDataListByPaymentId(String encryptedPaymentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Payment ID: [{}]. Get PSU data list by payment ID failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisCommonPaymentService.getPsuDataListByPaymentId(decryptIdOptional.get());
    }

    @ConstructorProperties(value={"securityDataService", "pisCommonPaymentService"})
    public PisCommonPaymentServiceInternalEncrypted(SecurityDataService securityDataService, PisCommonPaymentService pisCommonPaymentService) {
        this.securityDataService = securityDataService;
        this.pisCommonPaymentService = pisCommonPaymentService;
    }
}

