/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import de.adorsys.psd2.consent.repository.CryptoAlgorithmRepository;
import de.adorsys.psd2.consent.service.security.provider.CryptoInstanceFactory;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.CryptoProviderHolder;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CryptoConfig {
    private static final Logger log = LoggerFactory.getLogger(CryptoConfig.class);
    @Value(value="${xs2a.cms.encryption.defaultProvider.dataProvider:JcHZwvJMuc}")
    private String defaultDataProviderId;
    @Value(value="${xs2a.cms.encryption.defaultProvider.idProvider:psGLvQpt9Q}")
    private String defaultIdProviderId;

    @Bean
    public CryptoProviderHolder initCryptoProviders(CryptoAlgorithmRepository cryptoAlgorithmRepository) {
        Map<String, CryptoProvider> providerMap = this.getInitializedProviderMap(cryptoAlgorithmRepository);
        CryptoProviderHolder cryptoProviderHolder = new CryptoProviderHolder(providerMap, this.defaultDataProviderId, this.defaultIdProviderId);
        this.validateDefaultProviders(cryptoProviderHolder.getDefaultDataProvider(), cryptoProviderHolder.getDefaultIdProvider());
        log.info("Crypto providers are initialized: {}", cryptoProviderHolder.getInitializedProviders());
        log.info("Provider for Data encryption by default: {}", (Object)cryptoProviderHolder.getDefaultDataProvider());
        log.info("Provider for ID encryption by default: {}", (Object)cryptoProviderHolder.getDefaultIdProvider());
        return cryptoProviderHolder;
    }

    private Map<String, CryptoProvider> getInitializedProviderMap(CryptoAlgorithmRepository cryptoAlgorithmRepository) {
        return StreamSupport.stream(cryptoAlgorithmRepository.findAll().spliterator(), false).filter(crp -> StringUtils.isNotBlank((CharSequence)crp.getEncryptorClass()) && !crp.getEncryptorClass().equals("UNDEFINED")).map(crp -> this.getCryptoProviderInstance(crp.getEncryptorClass(), crp.getCryptoProviderId(), crp.getEncryptorParams())).filter(Objects::nonNull).collect(Collectors.toMap(CryptoProvider::getCryptoProviderId, crp -> crp));
    }

    private CryptoProvider getCryptoProviderInstance(String factoryClassName, String cryptoProviderId, String params) {
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            Object factoryImpl = factoryClass.newInstance();
            if (factoryImpl instanceof CryptoInstanceFactory) {
                return ((CryptoInstanceFactory)factoryImpl).initProvider(cryptoProviderId, params);
            }
        }
        catch (Exception ex) {
            log.info("Error creation {} factory: ", (Object)factoryClassName, (Object)ex);
        }
        return null;
    }

    private void validateDefaultProviders(CryptoProvider defaultDataProvider, CryptoProvider defaultIdProvider) {
        if (Objects.isNull(defaultDataProvider) || Objects.isNull(defaultIdProvider)) {
            log.error("Default providers are not initialized! DefaultDataProvider : {} , DefaultIdProvider {}", (Object)defaultDataProvider, (Object)defaultIdProvider);
            throw new IllegalArgumentException("Default providers are not initialized!");
        }
    }
}

