package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.consent.ConsentTppInformationEntity;
import de.adorsys.psd2.xs2a.core.consent.ConsentTppInformation;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-08-14T08:05:10+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class ConsentTppInformationMapperImpl implements ConsentTppInformationMapper {

    @Autowired
    private TppInfoMapper tppInfoMapper;

    @Override
    public ConsentTppInformation mapToConsentTppInformation(ConsentTppInformationEntity consentTppInformationEntity) {
        if ( consentTppInformationEntity == null ) {
            return null;
        }

        ConsentTppInformation consentTppInformation = new ConsentTppInformation();

        List<NotificationSupportedMode> list = consentTppInformationEntity.getTppNotificationContentPreferred();
        if ( list != null ) {
            consentTppInformation.setTppNotificationSupportedModes( new ArrayList<NotificationSupportedMode>( list ) );
        }
        consentTppInformation.setTppRedirectPreferred( consentTppInformationEntity.isTppRedirectPreferred() );
        consentTppInformation.setTppFrequencyPerDay( consentTppInformationEntity.getTppFrequencyPerDay() );
        consentTppInformation.setTppNotificationUri( consentTppInformationEntity.getTppNotificationUri() );
        consentTppInformation.setTppInfo( tppInfoMapper.mapToTppInfo( consentTppInformationEntity.getTppInfo() ) );
        consentTppInformation.setTppBrandLoggingInformation( consentTppInformationEntity.getTppBrandLoggingInformation() );

        return consentTppInformation;
    }

    @Override
    public ConsentTppInformationEntity mapToConsentTppInformationEntity(ConsentTppInformation consentTppInformation) {
        if ( consentTppInformation == null ) {
            return null;
        }

        ConsentTppInformationEntity consentTppInformationEntity = new ConsentTppInformationEntity();

        List<NotificationSupportedMode> list = consentTppInformation.getTppNotificationSupportedModes();
        if ( list != null ) {
            consentTppInformationEntity.setTppNotificationContentPreferred( new ArrayList<NotificationSupportedMode>( list ) );
        }
        consentTppInformationEntity.setTppRedirectPreferred( consentTppInformation.isTppRedirectPreferred() );
        consentTppInformationEntity.setTppInfo( tppInfoMapper.mapToTppInfoEntity( consentTppInformation.getTppInfo() ) );
        consentTppInformationEntity.setTppFrequencyPerDay( consentTppInformation.getTppFrequencyPerDay() );
        consentTppInformationEntity.setTppNotificationUri( consentTppInformation.getTppNotificationUri() );
        consentTppInformationEntity.setTppBrandLoggingInformation( consentTppInformation.getTppBrandLoggingInformation() );

        return consentTppInformationEntity;
    }
}
