/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.api.service.ConsentService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisService;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisPsuDataAuthorisation;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.repository.specification.AuthorisationSpecification;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.AccessMapper;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.CmsPsuAuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.migration.AisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuAisServiceInternal
implements CmsPsuAisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuAisServiceInternal.class);
    private final ConsentJpaRepository consentJpaRepository;
    private final AisConsentVerifyingRepository aisConsentRepository;
    private final AisConsentMapper consentMapper;
    private final AuthorisationRepository authorisationRepository;
    private final AuthorisationSpecification authorisationSpecification;
    private final AisConsentSpecification aisConsentSpecification;
    private final ConsentService aisConsentService;
    private final PsuDataMapper psuDataMapper;
    private final AisConsentUsageService aisConsentUsageService;
    private final CmsPsuService cmsPsuService;
    private final CmsPsuAuthorisationMapper cmsPsuAuthorisationMapper;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final ConsentDataMapper consentDataMapper;
    private final AisConsentLazyMigrationService aisConsentLazyMigrationService;
    private final AccessMapper accessMapper;

    @Transactional
    public boolean updatePsuDataInConsent(@NotNull PsuIdData psuIdData, @NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        return this.getAuthorisationByExternalId(authorisationId, instanceId).map(auth -> this.updatePsuData((AuthorisationEntity)auth, psuIdData)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update PSU  in consent failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional
    @NotNull
    public Optional<CmsAisConsentResponse> checkRedirectAndGetConsent(@NotNull String redirectId, @NotNull String instanceId) throws RedirectUrlIsExpiredException {
        Optional optionalAuthorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId));
        if (optionalAuthorisation.isPresent()) {
            AuthorisationEntity authorisation = (AuthorisationEntity)optionalAuthorisation.get();
            if (!authorisation.isRedirectUrlNotExpired()) {
                log.info("Authorisation ID [{}]. Check redirect URL and get consent failed, because authorisation is expired", (Object)redirectId);
                this.updateAuthorisationOnExpiration(authorisation);
                throw new RedirectUrlIsExpiredException(authorisation.getTppNokRedirectUri());
            }
            return this.createCmsAisConsentResponseFromAuthorisation(authorisation, redirectId);
        }
        log.info("Authorisation ID [{}]. Check redirect URL and get consent failed, because authorisation not found or has finalised status", (Object)redirectId);
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsAisAccountConsent> getConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.consentJpaRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId)).map(this.aisConsentLazyMigrationService::migrateIfNeeded).map(this::checkAndUpdateOnExpiration).map(this::mapToCmsAisAccountConsentWithAuthorisations);
    }

    @NotNull
    public Optional<CmsPsuAuthorisation> getAuthorisationByAuthorisationId(@NotNull String authorisationId, @NotNull String instanceId) {
        Optional optionalAuthorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (optionalAuthorisation.isPresent()) {
            AuthorisationEntity authorisation = (AuthorisationEntity)optionalAuthorisation.get();
            return Optional.of(this.cmsPsuAuthorisationMapper.mapToCmsPsuAuthorisation(authorisation));
        }
        log.info("Authorisation ID: [{}], Instance ID: [{}]. Get authorisation failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId, AuthenticationDataHolder authenticationDataHolder) throws AuthorisationIsExpiredException {
        Optional<ConsentEntity> actualAisConsent = this.getActualAisConsent(consentId, instanceId);
        if (actualAisConsent.isEmpty()) {
            log.info("Consent ID: [{}]. Update of authorisation status failed, because consent either has finalised status or not found", (Object)consentId);
            return false;
        }
        return this.getAuthorisationByExternalId(authorisationId, instanceId).map(authorisation -> this.updateScaStatusAndAuthenticationData(status, (AuthorisationEntity)authorisation, authenticationDataHolder)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public boolean confirmConsent(@NotNull String consentId, @NotNull String instanceId) throws WrongChecksumException {
        if (this.changeConsentStatus(consentId, ConsentStatus.VALID, instanceId)) {
            this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(consentId);
            return true;
        }
        log.info("Consent ID [{}]. Confirmation of consent failed because consent has finalised status or not found", (Object)consentId);
        return false;
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public boolean rejectConsent(@NotNull String consentId, @NotNull String instanceId) throws WrongChecksumException {
        return this.changeConsentStatus(consentId, ConsentStatus.REJECTED, instanceId);
    }

    @NotNull
    public List<CmsAisAccountConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        if (psuIdData.isEmpty()) {
            return Collections.emptyList();
        }
        return this.consentJpaRepository.findAll(this.aisConsentSpecification.byPsuDataInListAndInstanceId(psuIdData, instanceId)).stream().map(this.aisConsentLazyMigrationService::migrateIfNeeded).map(this::mapToCmsAisAccountConsentWithAuthorisations).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public boolean revokeConsent(@NotNull String consentId, @NotNull String instanceId) throws WrongChecksumException {
        return this.changeConsentStatus(consentId, ConsentStatus.REVOKED_BY_PSU, instanceId);
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public boolean authorisePartiallyConsent(@NotNull String consentId, @NotNull String instanceId) throws WrongChecksumException {
        return this.changeConsentStatus(consentId, ConsentStatus.PARTIALLY_AUTHORISED, instanceId);
    }

    @Transactional
    public boolean updateAccountAccessInConsent(@NotNull String consentId, @NotNull CmsAisConsentAccessRequest accountAccessRequest, @NotNull String instanceId) {
        Optional<ConsentEntity> aisConsentOptional = this.getActualAisConsent(consentId, instanceId);
        if (aisConsentOptional.isPresent()) {
            return this.updateAccountAccessInConsent(aisConsentOptional.get(), accountAccessRequest);
        }
        log.info("Consent ID [{}]. Update account access in consent failed, because consent not found or has finalised status", (Object)consentId);
        return false;
    }

    public Optional<List<CmsAisPsuDataAuthorisation>> getPsuDataAuthorisations(@NotNull String consentId, @NotNull String instanceId) {
        Optional<ConsentEntity> aisConsentOptional = this.getActualAisConsent(consentId, instanceId);
        if (aisConsentOptional.isEmpty()) {
            return Optional.empty();
        }
        List<AuthorisationEntity> consentAuthorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(aisConsentOptional.get().getExternalId(), AuthorisationType.AIS);
        return Optional.of(this.getPsuDataAuthorisations(consentAuthorisations));
    }

    @NotNull
    private List<CmsAisPsuDataAuthorisation> getPsuDataAuthorisations(List<AuthorisationEntity> authorisations) {
        return authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData())).map(auth -> new CmsAisPsuDataAuthorisation(this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getExternalId(), auth.getScaStatus())).collect(Collectors.toList());
    }

    private boolean updateAccountAccessInConsent(ConsentEntity consent, CmsAisConsentAccessRequest request) {
        if (consent.getConsentStatus() == ConsentStatus.VALID) {
            log.info("Consent ID [{}]. Can't execute updateAccountAccessInConsent, because AIS consent has already VALID status.", (Object)consent.getExternalId());
            return false;
        }
        LocalDate validUntil = request.getValidUntil();
        if (validUntil != null && validUntil.isBefore(LocalDate.now())) {
            log.info("Consent property validUntil: [{}] is in the past!", (Object)validUntil);
            return false;
        }
        AisAccountAccess requestedAisAccountAccess = request.getAccountAccess();
        if (requestedAisAccountAccess == null) {
            log.info("Consent ID [{}]. Update account access in consent failed, because AIS Account Access is null", (Object)consent.getExternalId());
            return false;
        }
        AisConsentData aisConsentDataNew = new AisConsentData((AccountAccessType)AccountAccessType.getByDescription((String)requestedAisAccountAccess.getAvailableAccounts()).orElse(null), (AccountAccessType)AccountAccessType.getByDescription((String)requestedAisAccountAccess.getAllPsd2()).orElse(null), (AccountAccessType)AccountAccessType.getByDescription((String)requestedAisAccountAccess.getAvailableAccountsWithBalance()).orElse(null), BooleanUtils.isTrue((Boolean)request.getCombinedServiceIndicator()));
        byte[] data = this.consentDataMapper.getBytesFromConsentData((Object)aisConsentDataNew);
        AccountAccess requestedAccountAccess = this.consentMapper.mapToAccountAccess(requestedAisAccountAccess);
        List<AspspAccountAccess> aspspAccountAccesses = this.accessMapper.mapToAspspAccountAccess(requestedAccountAccess);
        consent.setData(data);
        consent.setAspspAccountAccesses(aspspAccountAccesses);
        consent.setValidUntil(request.getValidUntil());
        consent.setFrequencyPerDay(request.getFrequencyPerDay());
        AdditionalInformationAccess requestedAdditionalInformationAccess = requestedAisAccountAccess.getAccountAdditionalInformationAccess();
        if (requestedAdditionalInformationAccess != null) {
            consent.setOwnerNameType(AdditionalAccountInformationType.findTypeByList((List)requestedAdditionalInformationAccess.getOwnerName()));
            consent.setTrustedBeneficiariesType(AdditionalAccountInformationType.findTypeByList((List)requestedAdditionalInformationAccess.getTrustedBeneficiaries()));
        }
        this.aisConsentUsageService.resetUsage(consent);
        try {
            this.aisConsentRepository.verifyAndUpdate(consent);
        }
        catch (WrongChecksumException e) {
            log.info("Consent ID [{}]. Update account access in consent failed, because consent has wrong checksum", (Object)consent.getExternalId());
            return false;
        }
        return true;
    }

    private boolean changeConsentStatus(String consentId, ConsentStatus status, String instanceId) throws WrongChecksumException {
        Optional aisConsentOptional = this.consentJpaRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId));
        if (aisConsentOptional.isPresent()) {
            ConsentEntity entity = this.aisConsentLazyMigrationService.migrateIfNeeded((ConsentEntity)aisConsentOptional.get());
            return this.updateConsentStatus(entity, status);
        }
        log.info("Consent ID [{}], Instance ID: [{}]. Change consent status failed, because AIS consent not found", (Object)consentId, (Object)instanceId);
        return false;
    }

    private ConsentEntity checkAndUpdateOnExpiration(ConsentEntity consent) {
        if (consent != null && consent.shouldConsentBeExpired()) {
            return this.aisConsentConfirmationExpirationService.expireConsent(consent);
        }
        return consent;
    }

    private Optional<ConsentEntity> getActualAisConsent(String consentId, String instanceId) {
        return this.consentJpaRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId)).map(this.aisConsentLazyMigrationService::migrateIfNeeded).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private boolean updateConsentStatus(ConsentEntity consent, ConsentStatus status) throws WrongChecksumException {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            log.info("Consent ID: [{}], Consent status: [{}]. Confirmation of consent failed in updateConsentStatus method, because consent has finalised status", (Object)consent.getExternalId(), (Object)consent.getConsentStatus().getValue());
            return false;
        }
        if (status == ConsentStatus.PARTIALLY_AUTHORISED) {
            consent.setMultilevelScaRequired(true);
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return this.aisConsentRepository.verifyAndSave(consent) != null;
    }

    private boolean updatePsuData(AuthorisationEntity authorisation, PsuIdData psuIdData) {
        PsuData newPsuData = this.psuDataMapper.mapToPsuData(psuIdData, authorisation.getInstanceId());
        if (newPsuData == null || StringUtils.isBlank((CharSequence)newPsuData.getPsuId())) {
            log.info("Authorisation ID : [{}]. Update PSU data in consent failed in updatePsuData method, because newPsuData or psuId in newPsuData is empty or null.", (Object)authorisation.getExternalId());
            return false;
        }
        Optional<PsuData> optionalPsuData = Optional.ofNullable(authorisation.getPsuData());
        if (optionalPsuData.isPresent()) {
            newPsuData.setId(optionalPsuData.get().getId());
        } else {
            log.info("Authorisation ID [{}]. No PSU data available in the authorisation.", (Object)authorisation.getExternalId());
            Optional<ConsentEntity> consentOptional = this.consentJpaRepository.findByExternalId(authorisation.getParentExternalId());
            if (consentOptional.isEmpty()) {
                log.info("Authorisation ID [{}]. Update PSU data in consent failed, couldn't find consent by the parent ID in the authorisation.", (Object)authorisation.getExternalId());
                return false;
            }
            ConsentEntity aisConsent = consentOptional.get();
            List<PsuData> psuDataList = (aisConsent = this.aisConsentLazyMigrationService.migrateIfNeeded(aisConsent)).getPsuDataList();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(newPsuData, psuDataList);
            if (psuDataOptional.isPresent()) {
                newPsuData = psuDataOptional.get();
                aisConsent.setPsuDataList(this.cmsPsuService.enrichPsuData(newPsuData, psuDataList));
            }
        }
        authorisation.setPsuData(newPsuData);
        this.authorisationRepository.save(authorisation);
        return true;
    }

    private boolean updateScaStatusAndAuthenticationData(@NotNull ScaStatus status, AuthorisationEntity authorisation, AuthenticationDataHolder authenticationDataHolder) {
        if (authorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID [{}], SCA status [{}]. Update authorisation status failed in updateScaStatusAndAuthenticationData method because authorisation has finalised status.", (Object)authorisation.getExternalId(), (Object)authorisation.getScaStatus().getValue());
            return false;
        }
        authorisation.setScaStatus(status);
        if (authenticationDataHolder != null) {
            this.enrichAuthorisationWithAuthenticationData(authorisation, authenticationDataHolder);
        }
        this.authorisationRepository.save(authorisation);
        return true;
    }

    private void enrichAuthorisationWithAuthenticationData(AuthorisationEntity authorisation, AuthenticationDataHolder authenticationDataHolder) {
        if (authenticationDataHolder.getAuthenticationData() != null) {
            authorisation.setScaAuthenticationData(authenticationDataHolder.getAuthenticationData());
        }
        if (authenticationDataHolder.getAuthenticationMethodId() != null) {
            authorisation.setAuthenticationMethodId(authenticationDataHolder.getAuthenticationMethodId());
        }
    }

    private void updateAuthorisationOnExpiration(AuthorisationEntity authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        this.authorisationRepository.save(authorisation);
    }

    private Optional<CmsAisConsentResponse> createCmsAisConsentResponseFromAuthorisation(AuthorisationEntity authorisation, String redirectId) {
        Optional<ConsentEntity> aisConsentOptional = this.consentJpaRepository.findByExternalId(authorisation.getParentExternalId());
        if (aisConsentOptional.isEmpty()) {
            log.info("Authorisation ID [{}]. Check redirect URL and get consent failed in createCmsAisConsentResponseFromAisConsent method, because AIS consent is null", (Object)redirectId);
            return Optional.empty();
        }
        ConsentEntity aisConsent = aisConsentOptional.get();
        aisConsent = this.aisConsentLazyMigrationService.migrateIfNeeded(aisConsent);
        CmsAisAccountConsent aisAccountConsent = this.mapToCmsAisAccountConsentWithAuthorisations(aisConsent);
        return Optional.of(new CmsAisConsentResponse(aisAccountConsent, redirectId, authorisation.getTppOkRedirectUri(), authorisation.getTppNokRedirectUri()));
    }

    private Optional<AuthorisationEntity> getAuthorisationByExternalId(@NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        Optional authorization = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (authorization.isPresent() && !((AuthorisationEntity)authorization.get()).isAuthorisationNotExpired()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Authorisation is expired", (Object)authorisationId, (Object)instanceId);
            throw new AuthorisationIsExpiredException(((AuthorisationEntity)authorization.get()).getTppNokRedirectUri());
        }
        return authorization;
    }

    private CmsAisAccountConsent mapToCmsAisAccountConsentWithAuthorisations(ConsentEntity entity) {
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(entity.getExternalId(), AuthorisationType.AIS);
        return this.consentMapper.mapToCmsAisAccountConsent(entity, authorisations);
    }

    @ConstructorProperties(value={"consentJpaRepository", "aisConsentRepository", "consentMapper", "authorisationRepository", "authorisationSpecification", "aisConsentSpecification", "aisConsentService", "psuDataMapper", "aisConsentUsageService", "cmsPsuService", "cmsPsuAuthorisationMapper", "aisConsentConfirmationExpirationService", "consentDataMapper", "aisConsentLazyMigrationService", "accessMapper"})
    public CmsPsuAisServiceInternal(ConsentJpaRepository consentJpaRepository, AisConsentVerifyingRepository aisConsentRepository, AisConsentMapper consentMapper, AuthorisationRepository authorisationRepository, AuthorisationSpecification authorisationSpecification, AisConsentSpecification aisConsentSpecification, ConsentService aisConsentService, PsuDataMapper psuDataMapper, AisConsentUsageService aisConsentUsageService, CmsPsuService cmsPsuService, CmsPsuAuthorisationMapper cmsPsuAuthorisationMapper, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, ConsentDataMapper consentDataMapper, AisConsentLazyMigrationService aisConsentLazyMigrationService, AccessMapper accessMapper) {
        this.consentJpaRepository = consentJpaRepository;
        this.aisConsentRepository = aisConsentRepository;
        this.consentMapper = consentMapper;
        this.authorisationRepository = authorisationRepository;
        this.authorisationSpecification = authorisationSpecification;
        this.aisConsentSpecification = aisConsentSpecification;
        this.aisConsentService = aisConsentService;
        this.psuDataMapper = psuDataMapper;
        this.aisConsentUsageService = aisConsentUsageService;
        this.cmsPsuService = cmsPsuService;
        this.cmsPsuAuthorisationMapper = cmsPsuAuthorisationMapper;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.consentDataMapper = consentDataMapper;
        this.aisConsentLazyMigrationService = aisConsentLazyMigrationService;
        this.accessMapper = accessMapper;
    }
}

