/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider.jwe;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.AESEncrypter;
import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JweCryptoProviderImpl
implements CryptoProvider {
    private static final Logger log = LoggerFactory.getLogger(JweCryptoProviderImpl.class);
    private static final EncryptionMethod METHOD = EncryptionMethod.A256GCM;
    private static final JWEAlgorithm ALGORITHM = JWEAlgorithm.A256GCMKW;
    private final String cryptoProviderId;
    private final int keyLength;
    private final int hashIterations;
    private final String skfAlgorithm;

    public JweCryptoProviderImpl(String cryptoProviderId, int keyLength, int hashIterations, String skfAlgorithm) {
        this.cryptoProviderId = cryptoProviderId;
        this.keyLength = keyLength;
        this.hashIterations = hashIterations;
        this.skfAlgorithm = skfAlgorithm;
    }

    @Override
    public Optional<EncryptedData> encryptData(byte[] data, String password) {
        try {
            Payload payload = new Payload(data);
            SecretKey secretKey = this.getSecretKey(password);
            JWEHeader header = new JWEHeader(ALGORITHM, METHOD);
            JWEObject jweObject = new JWEObject(header, payload);
            AESEncrypter encrypter = new AESEncrypter(secretKey.getEncoded());
            jweObject.encrypt((JWEEncrypter)encrypter);
            String encryptedData = jweObject.serialize();
            return Optional.of(new EncryptedData(encryptedData.getBytes()));
        }
        catch (JOSEException | GeneralSecurityException e) {
            log.info("Error encryption data: {}", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<DecryptedData> decryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            JWEObject jweObject = JWEObject.parse((String)new String(data));
            AESDecrypter decrypter = new AESDecrypter(secretKey.getEncoded());
            jweObject.decrypt((JWEDecrypter)decrypter);
            return Optional.of(new DecryptedData(jweObject.getPayload().toBytes()));
        }
        catch (Exception e) {
            log.info("Error encryption data. Data can't be parsed : {}", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public String getCryptoProviderId() {
        return this.cryptoProviderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getSecretKey(String password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] salt = new byte[16];
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, this.hashIterations, this.keyLength);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.skfAlgorithm);
            SecretKey secretKey = factory.generateSecret(keySpec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            return secretKeySpec;
        }
        finally {
            keySpec.clearPassword();
        }
    }
}

