/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider;

import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoProviderHolder {
    private static final Logger log = LoggerFactory.getLogger(CryptoProviderHolder.class);
    private final Map<String, CryptoProvider> initializedProviders;
    private final CryptoProvider defaultDataProvider;
    private final CryptoProvider defaultIdProvider;

    public CryptoProviderHolder(Map<String, CryptoProvider> initializedProviders, String defaultDataProviderId, String defaultIdProviderId) {
        this.initializedProviders = initializedProviders;
        this.defaultDataProvider = initializedProviders.get(defaultDataProviderId);
        this.defaultIdProvider = initializedProviders.get(defaultIdProviderId);
    }

    public CryptoProvider getDefaultDataProvider() {
        return this.defaultDataProvider;
    }

    public CryptoProvider getDefaultIdProvider() {
        return this.defaultIdProvider;
    }

    public Optional<CryptoProvider> getProviderById(String cryptoProviderId) {
        return Optional.ofNullable(this.initializedProviders.get(cryptoProviderId));
    }

    public Map<String, CryptoProvider> getInitializedProviders() {
        return this.initializedProviders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptoProviderHolder)) {
            return false;
        }
        CryptoProviderHolder other = (CryptoProviderHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, CryptoProvider> this$initializedProviders = this.getInitializedProviders();
        Map<String, CryptoProvider> other$initializedProviders = other.getInitializedProviders();
        if (this$initializedProviders == null ? other$initializedProviders != null : !((Object)this$initializedProviders).equals(other$initializedProviders)) {
            return false;
        }
        CryptoProvider this$defaultDataProvider = this.getDefaultDataProvider();
        CryptoProvider other$defaultDataProvider = other.getDefaultDataProvider();
        if (this$defaultDataProvider == null ? other$defaultDataProvider != null : !this$defaultDataProvider.equals(other$defaultDataProvider)) {
            return false;
        }
        CryptoProvider this$defaultIdProvider = this.getDefaultIdProvider();
        CryptoProvider other$defaultIdProvider = other.getDefaultIdProvider();
        return !(this$defaultIdProvider == null ? other$defaultIdProvider != null : !this$defaultIdProvider.equals(other$defaultIdProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptoProviderHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, CryptoProvider> $initializedProviders = this.getInitializedProviders();
        result = result * 59 + ($initializedProviders == null ? 43 : ((Object)$initializedProviders).hashCode());
        CryptoProvider $defaultDataProvider = this.getDefaultDataProvider();
        result = result * 59 + ($defaultDataProvider == null ? 43 : $defaultDataProvider.hashCode());
        CryptoProvider $defaultIdProvider = this.getDefaultIdProvider();
        result = result * 59 + ($defaultIdProvider == null ? 43 : $defaultIdProvider.hashCode());
        return result;
    }

    public String toString() {
        return "CryptoProviderHolder(initializedProviders=" + this.getInitializedProviders() + ", defaultDataProvider=" + this.getDefaultDataProvider() + ", defaultIdProvider=" + this.getDefaultIdProvider() + ")";
    }
}

